<script>
(function ($) {
    "use strict";

    const chartLine = (id, labels, dataSets, options = {}) => {
        new Chart(document.getElementById(id), {
            type: 'line',
            data: { labels, datasets: dataSets },
            options: { responsive: true, ...options },
        });
    };

    chartLine('order_summery', {!! json_encode($orderSummeryDate) !!}, [{
        label: 'Order Summery',
        data: {!! json_encode($orderSummeryQty) !!},
        borderColor: 'rgba(54, 162, 235,1)',
        backgroundColor: 'rgba(54, 162, 235,0.5)',
    }]);

    chartLine('order_auction_direct_product', {!! json_encode($purchaseOrderDate) !!}, [
        {
            label: 'Auction Sale',
            data: {!! json_encode($bidOrderAmount) !!},
            borderColor: 'rgba(255, 99, 132,1)',
            backgroundColor: 'rgba(255, 99, 132,0.5)',
        },
        {
            label: 'Direct Sale',
            data: {!! json_encode($purchaseOrderAmount) !!},
            borderColor: 'rgba(54, 162, 235,1)',
            backgroundColor: 'rgba(54, 162, 235,0.5)',
        }
    ]);

    chartLine('disposit_widthdraw', {!! json_encode($depositMonth) !!}, [
        {
            label: 'Deposit',
            data: {!! json_encode($depositSum) !!},
            borderColor: 'rgb(75, 192, 192)',
        },
        {
            label: 'Withdraw',
            data: {!! json_encode($withdrawSum) !!},
            borderColor: 'rgba(255, 99, 132,1)',
        }
    ]);

    chartLine('customer_merchant', {!! json_encode($customerDate) !!}, [
        {
            label: 'Merchants',
            data: {!! json_encode($artgalleryTotal) !!},
            borderColor: 'rgba(54, 162, 235,1)',
            backgroundColor: 'rgba(54, 162, 235,0.5)',
            type: 'bar',
            stack: 'combined',
        },
        {
            label: 'Customers',
            data: {!! json_encode($customerTotal) !!},
            borderColor: 'rgba(255, 99, 132,1)',
            backgroundColor: 'rgba(255, 99, 132,0.5)',
            stack: 'combined',
        }
    ], {
        scales: {
            y: {
                stacked: true,
            }
        }
    });

})(jQuery);
</script>
