@php
$widgetContent = [];
if (isset($singelWidgetData->widget_content)) {
$widgetContent = $singelWidgetData->getTranslation('widget_content');
}
@endphp
@if ($widgetContent)
<div class="discover-section mb-120 pt-120">
    <div class="container">
        <div class="row gy-4 ">
            <div class="col-lg-6 wow animate fadeInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="discover-content">
                    <h3>{{ isset($widgetContent['title']) ? $widgetContent['title'] : '' }}</h3>
                    <div class="content">{!! isset($widgetContent['content']) ? $widgetContent['content'] : '' !!}</div>
                </div>
                <div class="countdown-wrap">
                    <ul class="countdown-list">
                        <li class="single-countdown">
                            <div class="number">
                                @php
                                $customer_number = isset($widgetContent['customer_number'])
                                ? format_number($widgetContent['customer_number'])
                                : '';
                                @endphp
                                <h3 class="counter">{{ isset($customer_number['number']) && $customer_number['number'] ? $customer_number['number'] : 0 }}</h3>
                                <strong>{{ isset($customer_number['suffix']) && $customer_number['suffix'] ? $customer_number['suffix'] : '' }}</strong>
                            </div>
                            <span>{{ translate('Customers') }}</span>
                        </li>
                        <li class="single-countdown">
                            <div class="number">
                                @php
                                $collection_number = isset($widgetContent['collection_number'])
                                ? format_number($widgetContent['collection_number'])
                                : '';
                                @endphp
                                <h3 class="counter">{{ isset($collection_number['number']) && $collection_number['number'] ? $collection_number['number'] : 0 }}</h3>
                                <strong>{{ isset($collection_number['suffix']) && $collection_number['suffix'] ? $collection_number['suffix'] : '' }}</strong>
                            </div>
                            <span>{{ translate('Collections') }}</span>
                        </li>
                        <li class="single-countdown">
                            <div class="number">
                                @php
                                $auction_number = isset($widgetContent['auction_number'])
                                ? format_number($widgetContent['auction_number'])
                                : '';
                                @endphp
                                <h3 class="counter">{{ isset($auction_number['number']) && $auction_number['number'] ? $auction_number['number'] : 0 }}</h3>
                                <strong>{{ isset($auction_number['suffix']) && $auction_number['suffix'] ? $auction_number['suffix'] : '' }}</strong>
                            </div>
                            <span>{{ translate('Auctions') }}</span>
                        </li>
                        <li class="single-countdown">
                            <div class="number">
                                @php
                                $bidder_number = isset($widgetContent['bidder_number'])
                                ? format_number($widgetContent['bidder_number'])
                                : '';
                                @endphp
                                <h3 class="counter">{{ isset($bidder_number['number']) && $bidder_number['number'] ? $bidder_number['number'] : 0 }}</h3>
                                <strong>{{ isset($bidder_number['suffix']) && $bidder_number['suffix'] ? $bidder_number['suffix'] : '' }}</strong>
                            </div>
                            <span>{{ translate('Bidders') }}</span>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-6 wow animate fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                <div class="discover-section-image">
                    <div class="row g-2">
                        @if (isset($widgetContent['left_img']['img']) && $widgetContent['left_img']['img'])
                        <div class="col-lg-6">
                            <img src="{{ uploaded_asset($widgetContent['left_img']['img']) }}" alt="Left Image">
                        </div>
                        @endif
                        @if (isset($widgetContent['right_img']['img']) && $widgetContent['right_img']['img'])
                        <div class="col-lg-6">
                            <img src="{{ uploaded_asset($widgetContent['right_img']['img']) }}" alt="Right Image">
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
