@php
$form_title = '';
$form_sub_title = '';
$location_title = '';
$open_time = '';
$open_days = '';
$iframe_link = '';
$phones = [];
$emails = [];
if (isset($singelWidgetData->widget_content)) {
$widgetContent = $singelWidgetData->getTranslation('widget_content');
$form_title = isset($widgetContent['form_title']) ? $widgetContent['form_title'] : '';
$form_sub_title = isset($widgetContent['form_sub_title']) ? $widgetContent['form_sub_title'] : '';
$location_title = isset($widgetContent['location_title']) ? $widgetContent['location_title'] : '';
$open_time = isset($widgetContent['open_time']) ? $widgetContent['open_time'] : '';
$open_days = isset($widgetContent['open_days']) ? $widgetContent['open_days'] : '';
$iframe_link = isset($widgetContent['iframe_link']) ? $widgetContent['iframe_link'] : '';
$phones = isset($widgetContent['phones']) ? $widgetContent['phones'] : [];
$emails = isset($widgetContent['emails']) ? $widgetContent['emails'] : [];
}
$isContactPage = in_array(url()->current(), [url('contact-us'), url('contact')]);
@endphp

@if ($isContactPage)
<div class="contact-page mb-120 pt-120">
    <div class="container">
        <div class="row gy-5">
            <div class="col-lg-6">
                <div class="map-area">
                    <h3>{{$location_title}}</h3>
                    <div class="single-content">
                        <ul>
                            @foreach($phones as $phone)
                            <li>{{$phone['title']}} : <a href="tel:{{$phone['phone_number']}}">{{$phone['phone_number']}}</a></li>
                            @endforeach
                            @foreach($emails as $email)
                            <li>{{$email['title']}} : <a href="mailto:{{$email['email']}}">{{$email['email']}}</a></li>
                            @endforeach
                        </ul>
                        <ul class="opening-time">
                            <li>{{translate('at')}} - <span>{{$open_time}}</span></li>
                            <li>{{translate('from')}} - <span>{{$open_days}}</span></li>
                        </ul>
                    </div>
                    @if($iframe_link)
                    <div class="contact-map">
                        <iframe src="{{$iframe_link}}" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                    @endif
                </div>
            </div>
            <div class="col-lg-6">
                @endif
                <div class="enquery-section {{!$isContactPage ? 'style-3 mb-120' : 'style-2'}}">
                    <div class="container">
                        <div class="row {{!$isContactPage ? 'justify-content-center' : ''}} ">
                            <div class="col-lg-12 {{!$isContactPage ? 'mb-50' : 'mb-25'}}">
                                <div class="enquery-section-title {{!$isContactPage ? 'text-center' : ''}}">
                                    <h3>{{$form_title}}</h3>
                                    <p>{{$form_sub_title}}</p>
                                </div>
                            </div>
                            <div class="{{!$isContactPage ? 'col-xl-10' : ''}} col-lg-12 mb-20">
                                <div class="enquery-form-wrapper">
                                    <form action="{{route('contact.submit')}}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6 mb-30">
                                                <div class="form-inner3">
                                                    <label>{{translate('Name')}} <span class="text-color">*</span></label>
                                                    <input required type="text" name="name" placeholder="{{translate('Enter Name')}}">
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-30">
                                                <div class="form-inner3">
                                                    <label>{{translate('Email Address')}} <span class="text-color">*</span></label>
                                                    <input required type="email" name="email" placeholder="info@example.com">
                                                </div>
                                            </div>
                                            <div class="col-md-12 mb-40">
                                                <div class="form-inner3">
                                                    <label>{{translate('Message')}}</label>
                                                    <textarea name="message" placeholder="{{translate('Write your message')}}"></textarea>
                                                </div>
                                            </div>
                                            @if (get_setting('google_recapcha_check') == 1)
                                            <div class="g-recaptcha mb-3" data-sitekey="{{ get_setting('recaptcha_key') }}"></div>
                                            @if (Session::has('g-recaptcha-response'))
                                            <p class="text-danger"> {{ Session::get('g-recaptcha-response') }}</p>
                                            @endif
                                            @endif
                                            <div class="col-md-12 ">
                                                <div class="form-inner3">
                                                    <button class="primary-btn1 btn-hover">
                                                        <span>{{translate('Submit Here')}}</span>
                                                        <strong></strong>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            @if (!$isContactPage && $phones)
                            <div class="col-xl-10 col-lg-12 d-flex justify-content-center">
                                <div class="contact-area">
                                    <p>{{translate('Or Call Us')}} @foreach($phones as $phone)<a href="tel:{{$phone['phone_number']}}">{{$phone['phone_number']}}</a>@if(!$loop->last), @endif @endforeach</p>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @if ($isContactPage)
            </div>
        </div>
    </div>
</div>
@endif