@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')

<div class="auction-card-sidebar-section pt-50 mb-120 section">
    <div class="container">
        <div class="row gy-5">
            <div class="col-xl-12">
                <div class="section-title">
                    <h3 class="text-center mb-3">{{$title}}</h3>
                </div>
                <div class="list-grid-product-wrap">
                    <div class="row gy-4">
                        @if($results->count()> 0)
                        @foreach($results as $key=>$item)
                        <div class="col-lg-3 col-md-6 item wow animate fadeInDown" data-wow-delay="{{($key+1)*200}}ms" data-wow-duration="1500ms">
                            @include('frontend.template-' . selectedTheme() . '.partials.artwork')
                        </div>
                        @endforeach
                        @else
                        <div class="col-lg-12">
                            <div class="not-found text-center">
                                <div class="inner-cnt mb-30">
                                    <img src="{{ asset('uploads/sad.svg') }}" alt="No artwork">
                                    <h3>{{ translate('Sorry! No Artwork.') }}</h3>
                                    <p>{{ translate("It seems we can’t find what you’re looking for.") }}</p>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                    {!! $results->links('vendor.pagination.custom') !!}
                </div>

            </div>
        </div>
    </div>
</div>
@endsection