@extends('frontend.template-' . selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' . selectedTheme() . '.pages.dashboard.sidebar')
            <div class="dashboard-content-wrap style-2">
                <div class="dashboard-order-content">
                    <div class="dashboard-order-table">
                        <div class="dashboard-top-area">
                            <h4>{{$title ?? ''}}</h4>
                        </div>
                        @php
                        $statuses = [
                        1 => ['text' => 'Processing', 'class' => 'text-primary'],
                        3 => ['text' => 'Cancelled', 'class' => 'text-danger'],
                        4 => ['text' => 'Completed', 'class' => 'text-success'],
                        5 => ['text' => 'On Hold', 'class' => 'text-warning'],
                        6 => ['text' => 'Delivered', 'class' => 'text-success'],
                        7 => ['text' => 'Refunded', 'class' => 'text-danger'],
                        8 => ['text' => 'Shipped', 'class' => 'text-danger'],
                        ];
                        @endphp
                        <div class="table-title-area mb-3 text-color">
                            <h3>{{ $bidSingle->type == 1 ? translate('Bidding ID') : translate('Order ID') }} #{{
                                $bidSingle->order_number }}</h3>
                            <p>{{ $bidSingle->type == 1 ? translate('Bidding Date') : translate('Order Date') }}: {{
                                dateFormat($bidSingle->created_at) }}</p>
                            <p>{{ $bidSingle->type == 1 ? translate('Bidding Status') : translate('Order Status') }}:
                                @if($bidSingle->win_status == 1)
                                <span class="text-success fs-5 d-inline">{{ translate('Win') }}</span>
                                @elseif(isset($statuses[$bidSingle->status]))
                                <span class="{{ $statuses[$bidSingle->status]['class'] }} fs-5 d-inline">
                                    {{ translate($statuses[$bidSingle->status]['text']) }}
                                </span>
                                @endif
                            </p>
                        </div>
                        <table>
                            <thead>
                                <tr>
                                    <th>{{ translate('Image') }}</th>
                                    <th>{{ translate('Name') }}</th>
                                    <th>{{ translate('Quantity') }}</th>
                                    <th>{{ $bidSingle->type == 1 ? translate('Bid Amount') : translate('Price') }}</th>
                                    <th>{{ translate('Tax') . '(' . get_setting('tax_rate') . '%)' }}</th>
                                    <th>{{ translate('Total') }}</th>
                                    @if ($bidSingle->payment_status != 3 && $bidSingle->status == 2 && $bidSingle->win_status == 1)
                                    <th>{{ translate('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if ($bidSingle->transactions->count() > 0)
                                @foreach ($bidSingle->transactions as $bid_payment)
                                <tr>
                                    <td data-label="Image"><img src="{{uploaded_asset($bidSingle->artworks?->features_image)}}" alt="Image" width="50"></td>
                                    <td data-label="Artwork"><span class="table-text">{{$bidSingle->artworks?->getTranslation('name')}}</span>
                                    </td>
                                    <td data-label="Quantity"><span class="table-text">{{ $bidSingle->quantity }}</span>
                                    </td>
                                    <td data-label="Price"><span class="table-text">{{format_currency($bid_payment->amount)}}</span></td>
                                    <td data-label="Tax"><span class="table-text">{{
                                            format_currency($bid_payment->tax_amount) }}</span></td>
                                    <td data-label="Total"><span class="table-text">{{
                                            format_currency($bid_payment->total_amount) }}</span></td>
                                    @if ($bidSingle->payment_status != 3 && $bidSingle->status == 2 && $bidSingle->win_status == 1)
                                    <td data-label="Action" class="px-2">
                                        <button type="button" class="primary-btn1 btn-hover" data-bs-toggle="modal" data-bs-target="#finalPaymentModal">
                                            <span>{{
                                                translate('Pay Now') }}</span>
                                            <strong></strong>
                                        </button>
                                    </td>
                                    @endif
                                </tr>
                                @endforeach
                                @endif
                            </tbody>
                            @if ($bidSingle->type == 1)
                            <tfoot class="text-color">
                                <tr>
                                    <td @if ($bidSingle->payment_status != 3 && $bidSingle->status == 2 && $bidSingle->win_status == 1) colspan="4" @else colspan="3" @endif class="text-center fw-bold">{{('Total')}} =</td>
                                    <td class="text-center fw-bold">{{ format_currency($bidSingle->transactions?->sum('amount'))
                                        }}
                                    </td>
                                    <td class="text-center fw-bold">{{ format_currency($bidSingle->transactions->sum('tax_amount')) }}
                                    </td>
                                    <td class="text-center fw-bold">{{ format_currency($bidSingle->transactions->sum('total_amount')) }}
                                    </td>
                                </tr>
                            </tfoot>
                            @endif
                        </table>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="billing-address text-color">
                                    <h4>{{ translate('Billing Details') }}</h4>
                                    <p><strong>{{ translate('Full Name') }}</strong>: {{ $bidSingle->address?->first()?->name }}</p>
                                    <p><strong>{{ translate('Address') }}</strong>: {{ $bidSingle->address?->first()?->address }}
                                    </p>
                                    <p><strong>{{ translate('Post Code') }}</strong>: {{ $bidSingle->address?->first()?->post_code }}</p>
                                    <p><strong>{{ translate('Phone') }}</strong>: {{ $bidSingle->address?->first()?->phone }}</p>
                                    <p><strong>{{ translate('Email') }}</strong>: {{ $bidSingle->address?->first()?->email }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('frontend.template-'.selectedTheme().'.partials.final_payment_modal')
@endsection