@extends('frontend.template-' .selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' .selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' .selectedTheme() . '.pages.dashboard.sidebar')
            <div class="dashboard-content-wrap">
                <div class="portfolio-info-wrap">
                    <div class="row">
                        <div class="portfolio-content col-md-8">
                            <h4> {{translate('Hello')}}, {{Auth::user()->fname.' '.Auth::user()->lname}}
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0.624494 16.1705L1.29442 15.2695C1.2881 15.21 0.603137 13.3777 1.40055 11.7869C1.52756 11.5335 1.62721 11.2666 1.67512 10.9872C2.00744 9.04687 1.02427 6.4208 1.00545 6.36138C0.662735 5.27814 0.526654 4.84583 1.35474 4.44752C2.25601 4.01396 3.05677 4.51476 3.52436 5.36447C3.58786 5.47979 4.52875 7.22539 4.74441 9.49379L10.5526 1.68193C10.9638 1.12884 11.7329 0.958423 12.3208 1.31829C12.995 1.731 13.1567 2.62148 12.6958 3.24143L13.3731 2.33045C13.8047 1.74999 14.6253 1.59672 15.2167 2.01322C15.8284 2.44398 15.9615 3.29123 15.5179 3.88789C14.7271 4.95141 14.9089 4.70696 14.8228 4.8228C15.2788 4.20947 16.164 4.10347 16.7535 4.61144C17.2829 5.06755 17.3503 5.86531 16.9334 6.42609L15.6494 8.15308C16.1103 7.53317 17.0096 7.43151 17.599 7.95831C18.1128 8.4176 18.1712 9.20323 17.76 9.75633L11.4437 18.2515C10.7823 19.1411 9.87847 19.7442 8.89165 20.0374C7.96314 20.3133 7.58429 21.0461 7.47583 21.1608L7.43119 21.2209C7.05964 21.7205 6.35345 21.8244 5.85377 21.4529L0.85502 17.7362C0.358863 17.3674 0.255781 16.6664 0.624494 16.1705Z"
                                        fill="#F4D44E" />
                                    <path
                                        d="M5.14388 3.60513C5.69152 2.45268 6.4601 1.41895 7.406 0.562607C7.4682 0.504956 7.50518 0.425112 7.5089 0.340384C7.51263 0.255656 7.48281 0.172873 7.42592 0.109982C7.36902 0.0470905 7.28962 0.00915989 7.20495 0.00441317C7.12027 -0.000333544 7.03714 0.0284862 6.97356 0.0846243C5.96497 0.997663 5.14547 2.09986 4.56157 3.32867C4.52663 3.40564 4.52334 3.49326 4.55238 3.57264C4.58143 3.65202 4.64049 3.71682 4.71685 3.75307C4.79322 3.78933 4.88076 3.79413 4.96063 3.76646C5.0405 3.73879 5.10631 3.68085 5.14388 3.60513ZM6.95058 4.10902C7.33208 3.38364 7.82405 2.72199 8.40884 2.14776C8.46985 2.08788 8.50456 2.00622 8.50536 1.92074C8.50615 1.83527 8.47296 1.75297 8.41308 1.69197C8.3532 1.63097 8.27154 1.59625 8.18606 1.59546C8.10058 1.59466 8.01829 1.62786 7.95729 1.68774C7.32478 2.30885 6.79268 3.02451 6.38004 3.8091C6.34151 3.88463 6.33431 3.97231 6.35998 4.05312C6.38565 4.13393 6.44214 4.20137 6.51719 4.24083C6.59224 4.28028 6.67982 4.28857 6.76094 4.2639C6.84206 4.23922 6.9102 4.18358 6.95058 4.10902ZM19.1523 14.1771C20.1609 13.264 20.9804 12.1619 21.5643 10.9331C21.5997 10.856 21.6033 10.7681 21.5744 10.6884C21.5455 10.6087 21.4863 10.5436 21.4097 10.5073C21.3331 10.4709 21.2452 10.4662 21.1652 10.4941C21.0851 10.5221 21.0193 10.5805 20.982 10.6566C20.4344 11.8091 19.6658 12.8428 18.7198 13.6991C18.6885 13.7275 18.663 13.7618 18.6448 13.8C18.6267 13.8383 18.6163 13.8797 18.6142 13.922C18.6121 13.9642 18.6183 14.0065 18.6325 14.0464C18.6467 14.0862 18.6687 14.1229 18.6971 14.1543C18.8161 14.2859 19.0199 14.2969 19.1523 14.1771ZM18.1685 12.574C18.801 11.9529 19.3331 11.2372 19.7458 10.4526C19.7838 10.3772 19.7907 10.2897 19.7649 10.2092C19.7391 10.1287 19.6828 10.0616 19.6079 10.0222C19.5331 9.98288 19.4458 9.97451 19.3649 9.9989C19.284 10.0233 19.2158 10.0785 19.1752 10.1526C18.7937 10.878 18.3018 11.5397 17.717 12.114C17.6579 12.1743 17.6248 12.2553 17.6248 12.3397C17.6249 12.4242 17.658 12.5052 17.7171 12.5654C17.7763 12.6257 17.8567 12.6603 17.9411 12.6619C18.0255 12.6635 18.1071 12.632 18.1685 12.574Z"
                                        fill="#EAE9E8" />
                                    <path
                                        d="M15.458 3.96466L11.2346 9.64502C11.0215 9.93163 10.6101 9.97739 10.3392 9.74458C10.0929 9.53296 10.0522 9.16691 10.246 8.90631L13.6901 4.27417L13.6942 4.26867L13.699 4.26231L13.7039 4.25561L13.7075 4.25084L13.7075 4.25075L14.3742 3.35408C14.7298 2.87593 14.7146 2.23703 14.3798 1.78031C15.4366 1.71165 16.2431 2.90841 15.458 3.96466ZM13.1435 11.5194C12.9149 11.8269 12.4689 11.8653 12.1911 11.6013C12.0867 11.502 12.0223 11.368 12.0099 11.2244C11.9976 11.0809 12.0382 10.9378 12.1242 10.8222L15.7897 5.89219C16.1476 5.41082 16.1482 4.75503 15.8065 4.29037C16.9329 4.22415 17.6131 5.50797 16.9307 6.42573C15.2185 8.72881 14.9255 9.12287 13.1435 11.5194ZM6.28756 20.687L6.33221 20.6269C6.44066 20.5122 6.81951 19.7793 7.74802 19.5035C8.73479 19.2103 9.63864 18.6072 10.3001 17.7176L16.6163 9.22243C16.9737 8.74183 16.9763 8.08578 16.6337 7.62069C17.7567 7.55516 18.4431 8.83369 17.7573 9.75601L11.4411 18.2512C10.7796 19.1408 9.87582 19.7439 8.88901 20.0371C7.9605 20.313 7.58164 21.0458 7.47319 21.1605L7.42855 21.2205C7.057 21.7202 6.35081 21.8241 5.85113 21.4526L5.43137 21.1405C5.75862 21.1262 6.07689 20.9703 6.28756 20.687ZM11.5522 2.70762C11.9083 2.22873 11.8925 1.58859 11.5563 1.13179C11.7887 1.11641 12.0257 1.16234 12.2423 1.27561L12.2424 1.27543C12.3523 1.33297 12.4537 1.40548 12.5437 1.49088L12.5442 1.49131C13.0054 1.92989 13.0913 2.64338 12.7355 3.181L12.6933 3.2412L8.87908 8.37126C8.65633 8.67084 8.22162 8.70775 7.95156 8.45003C7.70238 8.21224 7.67136 7.82531 7.8795 7.55087L11.5522 2.70762ZM3.52189 5.3642C3.5615 5.43617 3.94268 6.14382 4.2762 7.21666L4.27654 7.21636C4.47738 7.86239 4.6609 8.64098 4.74194 9.49352C4.38839 9.96338 3.64091 9.73483 3.61062 9.14758L3.60095 8.95994C3.38533 6.69154 2.44445 4.94598 2.3809 4.83061C2.26897 4.62716 2.1377 4.44402 1.9907 4.28861C2.62445 4.27928 3.16838 4.72186 3.52189 5.3642Z"
                                        fill="#E8C842" />
                                    <path
                                        d="M5.30703 3.60378C5.26946 3.6795 5.20366 3.73744 5.12378 3.76511C5.04391 3.79279 4.95637 3.78798 4.88001 3.75173C4.80364 3.71547 4.74458 3.65067 4.71553 3.57129C4.68649 3.49191 4.68979 3.40429 4.72472 3.32732C5.30863 2.0985 6.12815 0.996287 7.13676 0.0832337C7.20017 0.0259194 7.28374 -0.00387255 7.36911 0.00040584C7.45447 0.00468423 7.53465 0.0426829 7.59201 0.10605C7.64934 0.169455 7.67913 0.25303 7.67486 0.3384C7.67058 0.42377 7.63257 0.503947 7.56919 0.561302C6.62327 1.41762 5.85468 2.45133 5.30703 3.60378ZM8.57625 1.6906C8.63611 1.75161 8.66929 1.8339 8.66849 1.91937C8.66769 2.00484 8.63298 2.08649 8.57199 2.14637C7.98718 2.7206 7.49521 3.38227 7.11373 4.10767C7.08638 4.15973 7.04531 4.20331 6.99496 4.2337C6.94462 4.26409 6.88692 4.28012 6.82811 4.28006C6.58904 4.28006 6.42937 4.02401 6.5431 3.80771C6.95575 3.02314 7.48785 2.30749 8.12035 1.68639C8.18138 1.62653 8.26369 1.59335 8.34917 1.59414C8.43466 1.59493 8.51633 1.62962 8.57625 1.6906ZM21.1451 10.6552C21.1821 10.5785 21.2479 10.5195 21.3282 10.4911C21.4085 10.4628 21.4968 10.4674 21.5737 10.5039C21.6507 10.5404 21.71 10.6059 21.7388 10.6861C21.7676 10.7662 21.7635 10.8545 21.7274 10.9317C21.1435 12.1605 20.324 13.2626 19.3154 14.1757C19.2563 14.2294 19.1792 14.2591 19.0993 14.259C18.8069 14.259 18.6635 13.8962 18.8831 13.6977C19.3549 13.2705 19.7838 12.7982 20.1635 12.2875C20.5432 11.7767 20.872 11.23 21.1451 10.6552ZM19.3384 10.1513C19.3784 10.0761 19.4466 10.0199 19.528 9.99481C19.6094 9.96975 19.6975 9.97794 19.7728 10.0176C19.8482 10.0572 19.9049 10.1251 19.9304 10.2064C19.9559 10.2877 19.9482 10.3757 19.9089 10.4513C19.4963 11.2359 18.9642 11.9516 18.3317 12.5727C18.2707 12.6326 18.1884 12.6658 18.1029 12.665C18.0174 12.6642 17.9358 12.6294 17.8759 12.5684C17.816 12.5074 17.7828 12.4251 17.7836 12.3397C17.7844 12.2542 17.8191 12.1725 17.8802 12.1127C18.4649 11.5384 18.9569 10.8767 19.3384 10.1513Z"
                                        fill="black" />
                                    <path
                                        d="M9.54577 3.25119C9.57974 3.27644 9.6084 3.30813 9.63011 3.34446C9.65183 3.38078 9.66618 3.42103 9.67234 3.4629C9.6785 3.50477 9.67635 3.54745 9.66602 3.58849C9.65569 3.62953 9.63737 3.66814 9.61212 3.7021L5.16152 9.68801C4.98573 9.92442 4.60989 9.81928 4.58204 9.52623C4.37098 7.30549 3.44011 5.59366 3.40054 5.52182C3.23498 5.22078 2.61937 4.27496 1.65309 4.73988C1.04276 5.03352 1.15418 5.20407 1.47598 6.27884C1.71217 6.94253 2.45901 9.24767 2.15144 11.0435C2.00384 11.9051 1.6598 11.9555 1.52548 13.0783C1.47168 13.5278 1.48814 13.986 1.5739 14.446C1.59461 14.5476 1.71187 15.0284 2.15759 15.5639C2.21226 15.6296 2.2386 15.7143 2.2308 15.7994C2.22301 15.8846 2.18173 15.9631 2.11604 16.0178C1.97901 16.1319 1.77577 16.1128 1.66212 15.9762C1.60319 15.9055 1.54679 15.8326 1.49303 15.7578L1.04173 16.3648C0.779583 16.7173 0.853189 17.2174 1.20566 17.4795L1.8837 17.9836C2.13271 18.1687 2.00032 18.5645 1.69121 18.5645C1.50919 18.5645 1.4795 18.4622 0.821049 17.9967C0.183352 17.5225 0.050235 16.6179 0.524436 15.9802L1.0988 15.2076C1.01699 14.8933 0.753845 14.101 0.885329 13.0016C1.02816 11.8085 1.39837 11.6217 1.51602 10.9347C1.80447 9.25068 1.02734 6.9409 0.868657 6.49497C0.861997 6.47619 0.858043 6.46459 0.856755 6.46047C0.517346 5.38759 0.293135 4.67873 1.37362 4.1589C2.34029 3.69389 3.35761 4.10678 3.96523 5.21086C4.00244 5.27849 4.78198 6.71188 5.11718 8.66729L9.09486 3.31753C9.1201 3.28356 9.1518 3.25489 9.18812 3.23317C9.22445 3.21144 9.2647 3.19709 9.30657 3.19093C9.34845 3.18477 9.39112 3.18692 9.43217 3.19726C9.47321 3.2076 9.51182 3.22592 9.54577 3.25119ZM2.6418 18.9489C2.66704 18.9149 2.69873 18.8862 2.73505 18.8645C2.77138 18.8428 2.81163 18.8284 2.85351 18.8223C2.89538 18.8161 2.93806 18.8183 2.97911 18.8286C3.02015 18.839 3.05876 18.8573 3.09271 18.8826L6.20441 21.1962C6.56075 21.4611 7.06606 21.3866 7.33092 21.0305C7.45961 20.895 7.89217 20.047 8.95822 19.7303C10.8742 19.1612 11.5198 17.7253 11.8833 17.3349C11.9349 17.268 12.0108 17.224 12.0945 17.2124C12.1782 17.2009 12.2631 17.2226 12.3309 17.2731C12.3988 17.3235 12.4441 17.3986 12.4571 17.4821C12.4701 17.5656 12.4498 17.6509 12.4006 17.7196C12.0604 18.0817 11.2941 19.7089 9.14174 20.3482C8.31438 20.594 7.98679 21.2663 7.84809 21.4151C7.372 22.0554 6.46226 22.1911 5.81976 21.7134L2.70806 19.3998C2.6395 19.3488 2.59402 19.2726 2.58159 19.1881C2.56917 19.1035 2.59082 19.0175 2.6418 18.9489Z"
                                        fill="black" />
                                    <path
                                        d="M13.3818 2.01168C14.3148 0.985158 16.0228 1.46228 16.2431 2.83792C16.3067 3.23465 16.2263 3.63082 16.0163 3.96761C17.3814 3.93817 18.1832 5.50481 17.354 6.61989L16.8498 7.29802C18.2401 7.28315 18.9938 8.85636 18.1806 9.95004L13.3032 16.5101C13.2732 16.5505 13.2342 16.5833 13.1892 16.6059C13.1443 16.6285 13.0946 16.6402 13.0443 16.6401C12.7834 16.6401 12.6265 16.3399 12.7859 16.1255C18.6521 8.2355 17.0428 10.4 17.6633 9.56542C18.195 8.8503 17.6467 7.85884 16.774 7.94749C16.2961 7.99595 16.0747 8.34301 16.0696 8.34744L13.1369 12.2919C13.1069 12.3323 13.0678 12.3651 13.0229 12.3876C12.9779 12.4102 12.9283 12.4219 12.878 12.4218C12.6163 12.4218 12.4605 12.1212 12.6196 11.9073L16.8368 6.23523C17.1582 5.80297 17.1004 5.19763 16.7052 4.8571C16.26 4.47352 15.5907 4.5497 15.2435 5.0166L11.2637 10.3693C11.2337 10.4097 11.1947 10.4425 11.1497 10.4651C11.1047 10.4877 11.0551 10.4994 11.0048 10.4993C10.9451 10.4993 10.8866 10.4826 10.8358 10.4513C10.7849 10.4199 10.7439 10.375 10.7171 10.3217C10.6903 10.2683 10.6788 10.2085 10.684 10.149C10.6892 10.0896 10.7108 10.0327 10.7464 9.98476L15.4214 3.69708C15.7576 3.24492 15.6567 2.60464 15.1933 2.27821C14.753 1.96824 14.1253 2.07862 13.7939 2.52429L8.88319 9.12912C8.85794 9.16309 8.82625 9.19174 8.78992 9.21346C8.75359 9.23517 8.71335 9.24952 8.67148 9.25568C8.62961 9.26184 8.58693 9.25969 8.54589 9.24936C8.50485 9.23903 8.46624 9.22072 8.43228 9.19547C8.39832 9.17022 8.36966 9.13852 8.34794 9.10219C8.32623 9.06587 8.31188 9.02562 8.30572 8.98375C8.29956 8.94188 8.30171 8.89921 8.31204 8.85816C8.32237 8.81712 8.34069 8.77852 8.36594 8.74455L12.5992 3.05061C12.9423 2.58926 12.8341 1.91268 12.3145 1.59467C11.8782 1.32753 11.289 1.45102 10.9732 1.87572L10.5145 2.49267C10.4893 2.52663 10.4576 2.55529 10.4213 2.57701C10.3849 2.59872 10.3447 2.61307 10.3028 2.61923C10.261 2.62539 10.2183 2.62324 10.1772 2.61291C10.1362 2.60258 10.0976 2.58426 10.0636 2.55901C10.0297 2.53376 10.001 2.50207 9.97929 2.46574C9.95757 2.42942 9.94322 2.38917 9.93706 2.3473C9.9309 2.30542 9.93305 2.26275 9.94338 2.22171C9.95371 2.18067 9.97203 2.14206 9.99728 2.1081L10.456 1.49116C11.2759 0.388324 13.0105 0.67746 13.3818 2.01168Z"
                                        fill="black" />
                                </svg>
                            </h4>
                            <p>{{translate('Welcome Back On Your Dashboard')}}</p>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-sm-9 text-end">
                                    <label class="text-color">{{translate('Art Gallery module')}}:</label>
                                </div>
                                <div class="col-sm-3">
                                    <form id="panel_dashboard" action="{{route('user.panel.status')}}" method="post">
                                        @csrf
                                        <label class="switch-btn">
                                            <input type="checkbox" class="is_dashboard" name="is_dashboard" value="1" {{
                                                Auth::user()->isDashboard == 1 ? 'checked' : '' }}>
                                            <span class="switch-slider round"></span>
                                        </label>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 pt-30">
                            <div class="single-content text-center">
                                <h6>{{translate('Total Bids')}}</h6>
                                <h2>{{$data['total_auction']}}</h2>
                            </div>
                        </div>
                        <div class="col-md-6 pt-30">
                            <div class="single-content text-center">
                                <h6>{{translate('Total Orders')}}</h6>
                                <h2>{{$data['total_order']}}</h2>
                            </div>
                        </div>
                        <div class="col-md-6 pt-30">
                            <div class="single-content text-center">
                                <h6>{{translate('Total Deposits')}}</h6>
                                <h2>{{$data['total_deposit']}}</h2>
                            </div>
                        </div>
                        <div class="col-md-6 pt-30">
                            <div class="single-content text-center">
                                <h6>{{translate('Total Wishlist')}}</h6>
                                <h2>{{$data['total_wishlist']}}</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection