@extends('frontend.template-' . selectedTheme() . '.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="dashboard-section mb-120">
    <div class="container">
        <div class="dashboard-wrapper">
            @include('frontend.template-' . selectedTheme() . '.pages.dashboard.sidebar')
            <div class="dashboard-content-wrap style-2">
                <div class="dashboard-order-content">
                    <div class="dashboard-order-table">
                        <div class="dashboard-top-area">
                            <h4>{{ $title ?? '' }}</h4>
                            <button type="button" class="primary-btn1 btn-hover" data-bs-toggle="modal" data-bs-target="#paymentModal">{{translate('New Deposit')}}</button>
                        </div>
                        <table>
                            <thead>
                                <tr>
                                    <th>{{translate('S.N')}}</th>
                                    <th>{{ translate('Method') }}</th>
                                    <th>{{ translate('Transaction ID') }}</th>
                                    <th>{{ translate('Amount') }}</th>
                                    <th>{{ translate('Status') }}</th>
                                    <th>{{ translate('Date') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($deposits->count()> 0)
                                @foreach($deposits as $key=>$deposit)
                                <tr>
                                    <td data-label="{{translate('S.N')}}"><span class="table-text">{{ ($deposits->currentpage() - 1) * $deposits->perpage() + $key + 1 }}</span></td>
                                    <td data-label="{{ translate('Method') }}"><span class="table-text">{{ucfirst($deposit->payment_method)}}</span></td>
                                    <td data-label="{{ translate('Transaction ID') }}"><span class="table-text">{{$deposit->transaction_id}}</span></td>
                                    <td data-label="{{ translate('Amount') }}"><span class="table-text">{{format_currency($deposit->total_amount)}}</span></td>
                                    <td data-label="{{ translate('Status') }}"><span class="{{$deposit->status  == 1 ? 'purple-color' : ($deposit->status  == 2 ? 'green-color' : 'red-color')}}">{{$deposit->status == 1 ? 'Processing' : ($deposit->status  == 2 ? 'Completed' : 'Cancelled')}}</span></td>
                                    <td data-label="{{ translate('Date') }}"><span class="table-text">{{$deposit->created_at}}</span></td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td data-label="{{ translate('Not Found') }}" colspan="6"><span class="table-text">{{translate('No Data Found')}}</span></td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                        {!! $deposits->links('vendor.pagination.frontend') !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('frontend.template-' . selectedTheme() . '.partials.payment_modal')
@endsection
