@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-' . selectedTheme() . '.partials.breadcrumb')
<div class="checkout-page mb-120">
    <div class="container">
        <form action="{{route('payment.process')}}" method="post" class="modal-require-validation" data-modal-stripe-publishable-key="{{ get_payment_method('stripe_key') }}" id="modal-payment-form">
            @csrf
            <input type="hidden" name="current_url" value="{{ URL::full() }}">
            <div class="row g-lg-4 gy-5">
                <div class="col-lg-6">
                    <div class="inquiry-form">
                        <div class="title">
                            <h4>{{translate('Billing Information')}}</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Full Name')}} <span class="text-color">*</span></label>
                                    <input type="text" name="name" placeholder="{{translate('Enter Full Name')}}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Phone')}} <span class="text-color">*</span></label>
                                    <input type="text" name="phone" placeholder="{{translate('Enter Phone Number')}}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Email')}} ({{translate('Optional')}})</label>
                                    <input type="email" name="email" placeholder="{{translate('Enter Email Address')}}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Address')}} <span class="text-color">*</span></label>
                                    <input type="text" name="address" placeholder="{{translate('Enter Address')}}" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Postal Code')}}</label>
                                    <input type="text" name="postal_code" placeholder="{{translate('Enter Postal Code')}}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-inner mb-30">
                                    <label>{{translate('Short Notes')}}</label>
                                    <textarea name="notes" placeholder="{{translate('Write Something...')}}"></textarea>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-inner">
                                    <label class="containerss">
                                        <input type="checkbox" name="save_info">
                                        <span class="checkmark"></span>
                                        <span class="text">{{translate('Save this information for next time')}}</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="inquiry-form">
                        <div class="title">
                            <h4>{{translate('Order Summary')}}</h4>
                        </div>
                        @php
                        $cartData = Session::get('cart_data');
                        $artworkSingle = App\Models\Artwork::find($cartData['artwork_id']);
                        $total_price = $artworkSingle->sale_type == 1 ? bid_minimum_deposit($cartData['price'], $artworkSingle->min_deposit, $artworkSingle->min_deposit_type) : $cartData['price'];
                        $tax = get_setting('tax_rate') > 0 ? $total_price * get_setting('tax_rate') / 100 : 0;
                        @endphp
                        <div class="cart-menu">
                            <div class="cart-body">
                                @if($cartData)
                                <ul>
                                    <li class="single-item">
                                        <div class="item-area">
                                            <div class="main-item">
                                                <div class="item-img">
                                                    <img src="{{ uploaded_asset($artworkSingle->features_image) }}" alt="{{$artworkSingle->name}}">
                                                </div>
                                                <div class="content-and-quantity">
                                                    <div class="content">
                                                        <div class="price-and-btn d-flex align-items-center justify-content-between">
                                                            <span>{{translate('Bid Amount').': '.format_currency($cartData['price'])}}</span>
                                                            <button type="reset" class="close-btn"><i class="bi bi-x"></i></button>
                                                        </div>
                                                        <h6><a href="{{ route('artwork.details', $artworkSingle->id) }}">{{$artworkSingle->name}}</a></h6>
                                                        <span>{{translate('Quantity').': '.$cartData['quantity']}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                                @endif
                            </div>
                            <div class="cart-footer">
                                <div class="pricing-area">
                                    <ul>
                                        <li><span>{{translate('Sub Total')}}</span><span>{{format_currency($total_price)}}</span></li>
                                        @if(get_setting('tax_rate') > 0)
                                        <li><span>{{translate('Tax')}} ({{get_setting('tax_rate')}}%)</span><span>{{format_currency($tax)}}</span></li>
                                        @endif
                                    </ul>
                                    <ul class="total">
                                        <li><span>{{translate('Total')}}</span><span>{{format_currency($total_price + $tax)}}</span></li>
                                    </ul>
                                </div>
                                <div class="choose-payment-method">
                                    <h6>{{translate('Select Payment Method')}}</h6>
                                    <div class="payment-option checkout-payment-option">
                                        <ul>
                                            @foreach (paymentMethods() as $key => $payment_method)
                                            <li class="{{$payment_method->slug}} {{$key == 0 ? 'active' : ''}}">
                                                <div class="custom-control custom-radio {{$payment_method->slug}}">
                                                    <label class="" for="payment_method_modal{{$payment_method->id}}">
                                                        <input type="radio" id="payment_method_modal{{$payment_method->id}}" name="payment_method" class="custom-control-input d-none" value="{{$payment_method->slug}}" {{$payment_method->slug == 'wallet' ? 'checked' : ''}}>

                                                        @if ($payment_method->logo)
                                                        <img src="{{ uploaded_asset($payment_method->logo) }}" alt="{{$payment_method->name}}" height="20">
                                                        @else
                                                        {{$payment_method->name}}
                                                        @endif
                                                        <div class="checked"><i class="bi bi-check"></i></div>
                                                    </label>
                                                </div>
                                            </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="pt-25 payment-option-hide mt-30" id="StripePayment">
                                        <div class="row g-4">
                                            <div class="col-md-12">
                                                <label class="text-color">{{ translate('Credit or Debit Card') }}</label>
                                                <div id="card-element"></div>
                                                <div id="card-errors" role="alert" class="text-danger mt-2"></div>
                                            </div>
                                        </div>
                                        <div class='form-row row pt-3'>
                                            <div class='col-md-12 modal-error form-group d-none'>
                                                <div class='alert-danger alert'>
                                                    {{ translate('Please correct the errors and try again') }}.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-inner">
                                    <input type="hidden" name="artwork_id" value="{{ $cartData['artwork_id'] }}">
                                    <input type="hidden" name="quantity" value="{{ $cartData['quantity'] }}">
                                    <input type="hidden" name="type" value="{{ $artworkSingle->sale_type == 1 ? 2 : 3 }}">
                                    <input type="hidden" name="amount" value="{{round($total_price,2)}}">
                                    <input type="hidden" name="tax_amount" value="{{round($tax,2)}}">
                                    <input type="hidden" name="total_amount" value="{{round($total_price + $tax,2)}}">
                                    <input type="hidden" name="bid_amount" value="{{ $artworkSingle->sale_type == 1 ? $cartData['price'] : 0 }}">
                                    <button class="primary-btn1 btn-hover" type="submit">
                                        <span>{{ translate('Place Order') }}</span>
                                        <strong></strong>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push('js')
<script src="https://js.stripe.com/v3/"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script src="{{ asset('frontend/js/payment-transaction.js') }}"></script>
@endpush