@php
if (Session::has('locale')) {
$locale = Session::get('locale', Config::get('app.locale'));
} else {
$locale = get_setting('DEFAULT_LANGUAGE', 'en');
}
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale == 'sa' ? 'rtl' : '' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @php
    $segments = request()->segments();
    @endphp
    <title>{{ $title ?? ucfirst(end($segments)) }} | {{ get_setting('company_name') }}</title>
    <link rel="icon" type="image/png" href="{{uploaded_asset(get_setting('front_favicon'))}}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="title" content="{{ $title ?? ucfirst(end($segments)) }} | {{ get_setting('company_name') }}">
    <meta name="description" content="{{$meta_description ?? ''}}">
    <meta name="keywords" content="{{$meta_keyward ?? ''}}">
    <meta property="og:title" content="{{ $title ?? ucfirst(end($segments)) }} | {{ get_setting('company_name') }}" />
    <meta property="og:description" content="{{$meta_description ?? ''}}" />
    <meta property="og:image" content="{{$meta_image ?? ''}}" />
    <meta property="og:url" content="{{ urlencode(url()->current()) }}" />
    <meta property="og:type" content="website" />
    <meta property="og:image:width" content="1200">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $title ?? ucfirst(end($segments)) }} | {{ get_setting('company_name') }}">
    <meta name="twitter:description" content="{{$meta_description ?? ''}}">
    <meta name="twitter:image" content="{{$meta_image ?? ''}}">
    <meta name="twitter:domain" content="{{url('/')}}">
    <meta name="twitter:url" content="{{ urlencode(url()->current()) }}">
    <meta name="brand_name" content="{{get_setting('company_name')}}">

    <link rel="canonical" href="{{ urlencode(url()->current()) }}">
    <link href="{{asset('frontend/css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{asset('frontend/css/bootstrap-icons.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('backend/css/bootstrap-icons.css')}}">
    <link rel="stylesheet" href="{{asset('frontend/css/swiper-bundle.min.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/select2.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{ asset('backend/plugins/cutealert/css/style.css') }}">
    <link rel="stylesheet" href="{{asset('frontend/css/animate.min.css')}}">
    <link rel="stylesheet" href="{{asset('frontend/css/jquery.fancybox.min.css')}}">
    <link href="{{asset('frontend/css/boxicons.min.css')}}" rel="stylesheet">

    <link rel="stylesheet" href="{{asset('frontend/css/style.css')}}?v={{ rand(1000, 9999) }}">
    <link rel="stylesheet" href="{{asset('frontend/css/custom.css')}}?v={{ rand(1000, 9999) }}">
</head>

<body id="body">
    <div class="tt-style-switch d-lg-flex d-none">
        <span class="dark">{{ translate('Dark') }}</span>
        <span class="light">{{ translate('Light') }}</span>
    </div>
    <div class="circle-container">
        <svg class="circle-progress svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919; stroke-dashoffset: 256.939;">
            </path>
        </svg>
    </div>
    @include('frontend.template-1.layouts.header')
    @include('frontend.template-1.layouts.navbar')
    <div class="main-content">
        @yield('content')
    </div>
    @include('frontend.template-1.layouts.footer')
    <script src="{{asset('frontend/js/jquery-3.7.1.min.js')}}"></script>
    <script src="{{asset('frontend/js/popper.min.js')}}"></script>
    <script src="{{asset('frontend/js/bootstrap.min.js')}}"></script>
    <script src="{{asset('frontend/js/swiper-bundle.min.js')}}"></script>
    <script src="{{asset('frontend/js/slick.min.js')}}"></script>
    <script src="{{asset('frontend/js/waypoints.min.js')}}"></script>
    <script src="{{asset('frontend/js/jquery.counterup.min.js')}}"></script>
    <script src="{{asset('backend/js/select2.min.js')}}"></script>
    <script src="{{ asset('backend/plugins/cutealert/js/cute-alert.js') }}"></script>
    <script src="{{ asset('backend/plugins/sweetalert/sweetalert.min.js') }}"></script>
    <script src="{{asset('frontend/js/jquery.fancybox.min.js')}}"></script>
    <script src="{{asset('frontend/js/wow.min.js')}}"></script>
    <script src="{{asset('frontend/js/jquery.marquee.min.js')}}"></script>
    <script src="{{asset('frontend/js/html2canvas.min.js')}}"></script>
    <script src="{{asset('frontend/js/jspdf.umd.min.js')}}"></script>
    <script src="{{asset('frontend/js/main.js')}}?v={{ rand(1000, 9999) }}"></script>
    <script src="{{asset('frontend/js/custom.js')}}?v={{ rand(1000, 9999) }}"></script>
    @stack('js')
    <script>
        @if(Session::has('success'))
        cuteToast({
            type: "success"
            , message: "{{ session('success') }}"
            , img: successAlertImage
            , timer: 2000
        });
        @endif

        @if(Session::has('error'))
        cuteToast({
            type: "error"
            , message: "{{ session('error') }}"
            , img: errorAlertImage
            , timer: 2000
        });
        @endif
    </script>

    @if (get_setting('tawk_enabled') == 1 && get_setting('tawk_code') !== '')
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {}
            , Tawk_LoadStart = new Date();
        (function() {
            var s1 = document.createElement("script")
                , s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = "{{ get_setting('tawk_code') }}";
            s1.charset = 'UTF-8';
            s1.setAttribute('crossorigin', '*');
            s0.parentNode.insertBefore(s1, s0);
        })();

    </script>
    @endif

</body>

</html>