<footer class="footer-section">
    <div class="container">
        <div class="footer-menu-wrap">
            <div class="row gy-5">
                @php
                $footers = [
                1 => ['class' => 'col-lg-4 col-md-6 col-sm-8'],
                2 => ['class' => 'col-lg-2 col-md-3 col-sm-4 d-flex justify-content-lg-end justify-content-md-center justify-content-sm-end', 'title' => 'footer1_title'],
                3 => ['class' => 'col-lg-2 col-md-3 col-sm-5 d-flex justify-content-md-end', 'title' => 'footer2_title'],
                4 => ['class' => 'col-md-4 col-sm-7 d-flex justify-content-lg-end justify-content-md-center justify-content-sm-end']
                ];
                @endphp

                @foreach ($footers as $i => $footer)
                @if (get_setting("footer{$i}_status") == 1)
                <div class="{{ $footer['class'] }}">
                    @if ($i == 1)
                    <div class="footer-content-area">
                        @if (get_setting('footer_logo'))
                        <a href="{{ route('home.page') }}" class="footer-logo">
                            <img src="{{ uploaded_asset(get_setting('footer_logo')) }}" alt="Footer Logo">
                        </a>
                        @endif
                        @if (get_setting('footer_desc_' . active_language()))
                        <p>{{ get_setting('footer_desc_' . active_language()) }}</p>
                        @endif
                        <ul class="social-list">
                            @foreach (['facebook', 'x', 'linkedin', 'youtube', 'instagram', 'pinterest'] as $s)
                            @if (get_setting("{$s}_link"))
                            <li>
                                <a href="{{ get_setting("{$s}_link") }}">
                                    <i class="bi bi-{{ $s == 'x' ? 'twitter-x' : $s }}"></i>
                                    <span>{{ ucfirst($s == 'x' ? 'Twitter X' : $s) }}</span>
                                </a>
                            </li>
                            @endif
                            @endforeach
                        </ul>
                    </div>
                    @elseif ($i == 2 || $i == 3)
                    <div class="footer-widget">
                        <div class="widget-title">
                            <h5>{{ translate(get_setting($footer['title'])) }}</h5>
                        </div>
                        @php
                        $widget_menu = \App\Models\MenuItem::with('page', 'category', 'blog', 'artist')
                        ->where('menu_id', $i)
                        ->whereNull('parent_id')
                        ->orderBy('order')->get();
                        @endphp
                        @if ($widget_menu->isNotEmpty())
                        <ul class="widget-list">
                            @foreach ($widget_menu as $menu)
                            <li>
                                <a target="{{ menuItemTarget($menu) }}" href="{{ menuItemUrl($menu) }}">{{ translate(menuItemTitle($menu)) }}</a>
                            </li>
                            @endforeach
                        </ul>
                        @endif
                    </div>

                    @elseif ($i == 4)
                    <div class="newsletter-and-payment-area">
                        @if (get_setting('footer_mailchimp_status') && get_setting('MAILCHIMP_API_KEY') && get_setting('MAILCHIMP_LIST_ID'))
                        <h4>{{ translate(get_setting('newsletter_title')) }}</h4>
                        <form action="{{ route('newsletter.subscribe') }}" method="POST">
                            @csrf
                            <div class="form-inner">
                                <input type="email" name="email" placeholder="{{ translate('Email Address') }}">
                                @error('email')
                                <div class="error text-danger">{{ $message }}</div>
                                @enderror
                                <button type="submit"><i class="bi bi-arrow-right"></i></button>
                            </div>
                        </form>
                        @endif
                        @if (get_setting('payment_method_img'))
                        <div class="payment-area">
                            <h6>{{ translate(get_setting('payment_method_title')) }}</h6>
                            <ul class="payment-options">
                                <img class="img-fluid" src="{{ uploaded_asset(get_setting('payment_method_img')) }}" alt="Payment Image">
                            </ul>
                        </div>
                        @endif
                    </div>
                    @endif
                </div>
                @endif
                @endforeach
            </div>
        </div>
        @if(get_setting('footer_bottom') == 1)
        <div class="footer-bottom">
            @if (get_setting('front_copyright_' . active_language()))
            <div class="copyright-area">
                {!! get_setting('front_copyright_' . active_language()) !!}
            </div>
            @endif
            @if(get_setting('footer_bottom_menu') == 1)
            @php
            $bottomMenu = \App\Models\MenuItem::with('page', 'category', 'blog', 'artist')
            ->where('menu_id', 4)
            ->whereNull('parent_id')
            ->orderBy('order')->get();
            @endphp
            @if ($bottomMenu->isNotEmpty())
            <div class="footer-bottom-right">
                <ul>
                    @foreach ($bottomMenu as $bmenu)
                    <li>
                        <a target="{{ menuItemTarget($bmenu) }}" href="{{ menuItemUrl($bmenu) }}">{{ translate(menuItemTitle($bmenu)) }}</a>
                    </li>
                    @endforeach
                </ul>
            </div>
            @endif
            @endif
        </div>
        @endif
    </div>
</footer>
