@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
        <a href="{{ route('dashboard.supports.index') }}" class="eg-btn btn--primary back-btn"> <img src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
            {{ translate('Go Back') }}</a>
    </div>
</div>
<div class="eg-card product-card">
    <form action="{{ route('dashboard.supports.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-lg-6">
                <div class="form-inner mb-35">
                    <label>{{ translate('Name') }}</label>
                    <input type="text" class="username-input" value="{{ Auth::user()->fname ? Auth::user()->fname.' '.Auth::user()->lname : '' }}" placeholder="{{translate('Enter Your Name')}}" readonly>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-inner mb-35">
                    <label>{{ translate('Email Address') }}</label>
                    <input type="text" class="username-input" value="{{ Auth::user()->email }}" placeholder="{{translate('Enter Your Email')}}" readonly>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="form-inner mb-35">
                    <label>{{ translate('Subject') }} <span class="text-danger">*</span></label>
                    <input type="text" name="subject" class="username-input" placeholder="{{translate('Enter Your Subject')}}">
                    @error('subject')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-inner mb-35">
                    <label>{{ translate('Department') }} <span class="text-danger">*</span></label>
                    <select class="select2" name="department">
                        <option value="2"> {{translate('General Support')}}</option>
                        <option value="1"> {{translate('Technical Support')}}</option>
                        <option value="3">{{translate('Payment Issue')}}</option>
                        <option value="4"> {{translate('Other Issue')}}</option>
                    </select>
                    @error('department')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-inner mb-35">
                    <label>{{ translate('Priority') }} <span class="text-danger">*</span></label>
                    <select class="select2" name="priority">
                        <option value="1">{{translate('High')}}</option>
                        <option value="2" selected>{{translate('Medium')}}</option>
                        <option value="3">{{translate('Low')}}</option>
                    </select>
                    @error('priority')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-12">
                <div class="form-inner mb-35">
                    <label>{{ translate('Message') }}</label>
                    <textarea class="summernote" name="description"></textarea>
                    @error('description')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-lg-12">
                <div class="form-inner">
                    <div id="inputTypeFile">
                        <div class=" mb-3 row g-3">
                            <div class="col-12">
                                <input type="file" name="attachment[]" placeholder="{{ translate('No File Choosen') }}">
                            </div>
                            <div class="input-group-append"></div>
                        </div>
                    </div>
                    <div id="newInputFile"></div>
                    <div class="add-btn-area pt-1 text-end">
                        <button id="addRow2" type="button" class="eg-btn btn--red medium-btn"><i class="bi bi-plus-lg"></i> {{ translate('Add More') }}</button>
                    </div>
                </div>
            </div>
            <div class="button-group mt-15 text-center  ">
                <input type="submit" class="eg-btn btn--green medium-btn me-3" value="{{ translate('Send') }}">
            </div>
        </div>
    </form>
</div>
@endsection