@if (@isset($widgetContent))
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $widgetContent->ui_card_number }}">
    <div class="accordion-header">
        <div class="section-name"> {{ $widgetContent->widget?->widget_name }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $widgetContent->id) }}" {{ $widgetContent->status == 1 ? 'checked' : '' }} type="checkbox" role="switch" id="{{ $widgetContent->id }}">
                    <label class="form-check-label d-none" for="{{ $widgetContent->id }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $widgetContent->id }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse ">
        <div class="accordion-body">
            @php
            $widgetContents= $widgetContent->getTranslation("widget_content",$lang);
            @endphp
            <form enctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $widgetContent->ui_card_number }}">
                <input type="hidden" name="page_id" value="{{ $widgetContent->page_id }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $widgetContent->widget_slug }}">
                <div class="row">
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][title]" value="{{ isset($widgetContents['title']) ? $widgetContents['title'] : '' }}">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Sub Title') }}" value="{{ isset($widgetContents['sub_title']) ? $widgetContents['sub_title'] : '' }}" name="content[0][sub_title]">
                        </div>
                    </div>
                </div>
                <hr>
                <div class="testimonial-area">
                    @if (isset($widgetContents['testimonials']))
                    @php
                    $count = 0;
                    @endphp
                    @foreach ($widgetContents['testimonials'] as $key => $testimonial)
                    @php
                    $count++;
                    @endphp
                    <div class="row align-items-center content">
                        <div class="col-sm-11">
                            <div class="row">
                                <div class="col-sm-12 mb-2">
                                    <div class="form-inner">
                                        <label>{{ translate('Title') }}</label>
                                        <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][testimonials][{{ $count }}][title]" value="{{ isset($testimonial['title']) ? $testimonial['title'] : '' }}">
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-2">
                                    <div class="form-inner">
                                        <label> {{ translate('Review') }}</label>
                                        <textarea class="username-input" placeholder="{{ translate('Enter Review') }}" name="content[0][testimonials][{{ $count }}][review]">{{isset($testimonial['review']) ?   $testimonial['review']  : ''}}</textarea>
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <div class="form-inner">
                                        <label> {{ translate('Name') }}</label>
                                        <input type="text" class="username-input" placeholder="{{ translate('Enter Name') }}" name="content[0][testimonials][{{ $count }}][name]" value="{{ isset($testimonial['name']) ? $testimonial['name'] : '' }}">
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <div class="form-inner">
                                        <label> {{ translate('Designation') }}</label>
                                        <input type="text" class="username-input" placeholder="{{ translate('Enter Designation') }}" name="content[0][testimonials][{{ $count }}][designation]" value="{{ isset($testimonial['designation']) ? $testimonial['designation'] : '' }}">
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <div class="form-inner">
                                        <label> {{ translate('Date') }}</label>
                                        <input type="text" class="username-input datepicker" placeholder="{{ translate('Enter Date') }}" name="content[0][testimonials][{{ $count }}][date]" value="{{ isset($testimonial['date']) ? $testimonial['date'] : '' }}">
                                    </div>
                                </div>
                                <div class="col-sm-6 mb-2">
                                    <div class="form-inner">
                                        <label>{{ translate('Image') }}</label>
                                        <div class="d-flex align-items-center">
                                            <input type="file" class="username-input widget-image-upload" name="image" data-folder="/uploads/files/">
                                            <input type="hidden" name="content[0][testimonials][{{ $count }}][img]" id="old_file" value="{{ isset($testimonial['img']) ? $testimonial['img'] : '' }}">
                                            @if (isset($testimonial['img']))
                                            <div class="ms-2">
                                                <img height="40" width="auto" src="{{ asset('uploads/files/' . $testimonial['img']) }}" alt="">
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-1 text-center">
                            <button class="remove-information remove text-danger border-0">
                                <i class="bi  bi-trash"></i>
                            </button>
                        </div>
                    </div>
                    @endforeach
                    @endif
                </div>
                <div class="add-row">
                    <button type="button" class="add-testimonial-btn eg-btn btn--primary back-btn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                            <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                        </svg>
                    </button>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@else
<div class="sortable-item accordion-item allowPrimary" data-code="{{ $randomId }}">
    <div class="accordion-header" id="herosection">
        <div class="section-name"> {{ $widgetName }}
            <div class="collapsed d-flex">
                <div class="form-check form-switch me-2">
                    <input class="form-check-input status-change" data-action="{{ route('dashboard.pages.widget.status.change', $randomId) }}" checked type="checkbox" role="switch" id="{{ $randomId }}">
                    <label class="form-check-label d-none" for="{{ $randomId }}"> </label>
                </div>
                <div class="collapsed-action-btn edit-action action-icon me-2">
                    <i class="bi bi-pencil-square"></i>
                </div>
                <div class="action-icon delete-action" data-id="{{ $randomId }}">
                    <i class="bi bi-trash"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="accordion-collapse collapse show">
        <div class="accordion-body">
            <form eenctype="multipart/form-data" data-action="{{ route('dashboard.pages.widget.save') }}" class="form" method="POST">
                @csrf
                <input type="hidden" name="ui_card_number" value="{{ $randomId }}">
                <input type="hidden" name="page_id" value="{{ $pageId }}">
                <input type="hidden" name="widget_slug" class="widget-slug" value="{{ $slug }}">
                <div class="row">
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Title') }}" name="content[0][title]">
                        </div>
                    </div>
                    <div class="col-sm-12 mb-2">
                        <div class="form-inner">
                            <label>{{ translate('Sub Title') }}</label>
                            <input type="text" class="username-input" placeholder="{{ translate('Enter Sub Title') }}" name="content[0][sub_title]">
                        </div>
                    </div>
                </div>
                <hr>
                <div class="testimonial-area">
                </div>
                <div class="add-row">
                    <button type="button" class="add-testimonial-btn eg-btn btn--primary back-btn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-plus" viewBox="0 0 16 16">
                            <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z" />
                        </svg>
                    </button>
                </div>
                <div class="button-area text-end">
                    <button type="submit" class="eg-btn btn--green medium-btn shadow">{{ translate('Save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
