@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
        <div class="language-changer">
            <span>{{translate('Language Translation')}}: </span>
            @foreach (\App\Models\Language::all() as $key => $language)
            @if($lang == $language->code)
            <img src="{{ asset('flags/'.$language->code.'.png') }}" class="mr-3" height="16">
            @else
            <a href="{{route('dashboard.pages.edit',['id'=>$page->id, 'lang'=>$language->code] )}}"><img src="{{ asset('flags/'.$language->code.'.png') }}" class="mr-3" height="16"></a>
            @endif
            @endforeach
        </div>
        <a href="{{ route('dashboard.pages.index') }}" class="eg-btn btn--primary back-btn"> <img src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
            {{ translate('Go Back') }}</a>
    </div>
</div>
<div class="row">
    <div class="wrap_menu">
        <div class="col-lg-12">
            <div class="eg-card product-card">
                <form class="form" data-action="{{ route('dashboard.pages.update', $page->id) }}" enctype="multipart/form-data">
                    @method('patch')
                    @csrf
                    <input type="hidden" name="lang" id="lang" value="{{ $lang }}">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-inner mb-25">
                                <label> {{ translate('Name') }} <span class="text-danger"><b>*</b></span></label>
                                <input type="text" class="username-input" placeholder="{{ translate('Write Page Name') }}" name="name" value="{{ $page->getTranslation('name') }}">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-inner mb-25">
                                <label> {{ translate('Slug') }} <span class="text-danger"><b>*</b></span> </label>
                                <input type="text" class="username-input" placeholder="{{ translate('Write Page Slug') }}" name="slug" value="{{ $page->slug }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="form-check">
                                <label class="form-check-label" for="seoPage">
                                    <input class="form-check-input seo-page-checkbox" name="enable_seo" {{ $page->enable_seo == 1 ? 'checked' : '' }} type="checkbox" id="seoPage">
                                    <b>{{ translate('Allow Page SEO') }}</b>
                                </label>
                            </div>
                        </div>
                        <div class="row mt-3 seo-content">
                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label> {{ translate('Meta Title') }} <span class="text-danger"><b>*</b></span></label>
                                    <input type="text" class="username-input" name="meta_title" value="{{ $page->getTranslation('meta_title') }}" placeholder="{{translate('Enter Meta Title')}}" />
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Meta Keyward') }}</label>
                                    <input type="text" name="meta_keyward" value="{{ old('meta_keyward', $page->getTranslation('meta_keyward')) }}" data-role="tagsinput" placeholder="{{ translate('Enter Meta Keyward') }}">
                                    @error('meta_keyward')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label> {{ translate('Meta Description') }}</label>
                                    <textarea name="meta_description" placeholder="{{translate('Enter Meta Description')}}">{{ $page->getTranslation('meta_description') }}</textarea>
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label> {{ translate('Meta Image') }}</label>
                                    <input type="file" name="meta_image">
                                    @if($page->meta_image)
                                    <img class="mt-3" src="{{uploaded_asset($page->meta_image)}}" alt="Meta Image" width="100">
                                    @endif
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="form-check">
                                <label class="form-check-label" for="is_bread_crumb">
                                    <input class="form-check-input is_bread_crumb" name="is_bread_crumb" {{ $page->is_bread_crumb == 1 ? 'checked' : '' }} type="checkbox" id="is_bread_crumb">
                                    <b>{{ translate('Bread Crumb Enable') }}</b>
                                </label>
                            </div>
                        </div>
                        <div class="row mt-3 bread-content">
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label> {{ translate('Short Bio') }}</label>
                                    <textarea name="short_bio" placeholder="{{translate('Enter Short Bio')}}">{{ $page->getTranslation('short_bio') }}</textarea>
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label> {{ translate('Background Image') }}</label>
                                    <input type="file" name="background_image">
                                    @if($page->background_image)
                                    <img class="mt-3" src="{{uploaded_asset($page->background_image)}}" alt="Background Image" width="100">
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-inner mb-35 mt-3">
                        <button type="submit" class="eg-btn btn--green btn shadow  me-3">{{ translate('Published') }}</button>
                        <a class="eg-btn btn--primary btn shadow  me-3" href="{{ $page->slug == 'home' ? url('/') : url($page->slug) }}">{{translate('View Page')}}</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-3 widget-item widget-item-list ">
        <div class="row">
            @foreach ($widgetList as $item)
            <div class="col-sm-6">
                <div class="widget-name add-element text-center" data-slug="{{ $item->widget_slug }}" data-page-id="{{ $page->id }}" data-widget-name="{{ $item->widget_name }}">
                    <div class="icon mb-3"> {!! $item->icon !!} </div>
                    <div class="section-name">
                        <p>{{ $item->widget_name }}</p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    <div class="col-sm-9 dragSortableItems">
        <div class="eg-card product-card">
            <div name="active_widget_list" class="sortable-list active_widget_list  accordion sortable-widget-item">
                @if ($page->widgetContents?->count() > 0)
                @foreach ($page->widgetContents as $widgetContent)
                @include('backend.pages.widgets.' . $widgetContent->widget_slug, [
                'widgetContent' => $widgetContent,
                ])
                @endforeach
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ asset('backend/plugins/sweetalert/sweetalert.min.js') }}"></script>
@include('js.admin.widget')
@endpush
