@php
    if (Session::has('locale')) {
        $locale = Session::get('locale', Config::get('app.locale'));
    } else {
        $locale = get_setting('DEFAULT_LANGUAGE', 'en');
    }
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale == 'sa' ? 'rtl' : '' }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $page_title ?? '' }}</title>
    <link rel="icon" type="image/png" href="{{uploaded_asset(get_setting('front_favicon'))}}">
    <link rel="stylesheet" href="{{asset('backend/css/all.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/boxicons.min.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/bootstrap-icons.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/jquery-ui.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/select2.min.css')}}">
    <link rel="stylesheet" href="{{asset('backend/css/summernote-lite.min.css')}}">
    <link rel="stylesheet" href="{{ asset('backend/css/bootstrap-tagsinput.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/plugins/dropzone/dropzone.min.css') }}">
    <!-- Cute Alert CSS -->
    <link rel="stylesheet" type="text/css" href="{{ asset('backend/plugins/cutealert/css/style.css') }}">
    <link rel="stylesheet" href="{{asset('backend/css/style.css')}}?v={{ rand(1000, 9999) }}">
    <link rel="stylesheet" href="{{asset('backend/css/custom.css')}}?v={{ rand(1000, 9999) }}">
    @stack('css')
    <script>
        var successAlertImage = "{{ asset('backend/plugins/cutealert/img/success.svg') }}";
        var errorAlertImage = "{{ asset('backend/plugins/cutealert/img/error.svg') }}";
        var questionAlertImage = "{{ asset('backend/plugins/cutealert/img/question.svg') }}";
        var warningALertImage = "{{ asset('backend/plugins/cutealert/img/warning.svg') }}";
        var infoALertImage = "{{ asset('backend/plugins/cutealert/img/info.svg') }}";
    </script>
</head>
<body>

    <div class="layout-wrapper">
        <!-- header-area -->
        @include('backend.layouts.header')

        <!-- main-container -->

        <div class="main-container">
            <!-- sidebar-area -->
            @include('backend.layouts.sidebar')
            <!-- main-content -->
            <div class="main-content">
                <!-- page-content -->
                @yield('content')
            </div>
            <div class="footer">
                @stack('footer')
            </div>
        </div>
    </div>
    
    <script>
        let baseUrl = "{{ url('/') }}"
    </script>
    
    <script src="{{asset('backend/js/jquery-3.7.1.min.js')}}"></script>
    <script src="{{asset('backend/js/jquery-ui.js')}}"></script>
    <script src="{{asset('backend/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('backend/js/summernote-lite.min.js')}}"></script>
    <script src="{{asset('backend/js/fontawesome.min.js')}}"></script>
    <script src="{{asset('backend/js/select2.min.js')}}"></script>
    <script src="{{asset('backend/js/bootstrap-tagsinput.min.js')}}"></script>
    <script src="{{ asset('backend/plugins/dropzone/dropzone.min.js') }}"></script>
    <!-- Cute Alert JS -->
    <script src="{{ asset('backend/plugins/cutealert/js/cute-alert.js') }}"></script>
    <!-- Sweet Alert JS -->
    <script src="{{ asset('backend/plugins/sweetalert/sweetalert.min.js') }}"></script>
    <script src="{{ asset('backend/js/html2pdf.bundle.min.js') }}"></script>
    <script src="{{asset('backend/js/main.js')}}?v={{ rand(1000, 9999) }}"></script>
    <script src="{{asset('backend/js/custom.js')}}?v={{ rand(1000, 9999) }}"></script>

    @if (Session::has('locale'))
        @if (Session::get('locale') == 'sa')
            <link rel="stylesheet" href="{{ asset('backend/css/rtl.css') }}">
        @endif
    @endif

    @stack('js')

    <script>
        @if (Session::has('success'))
            cuteToast({
                type: "success",
                message: "{{ session('success') }}",
                img: successAlertImage,
                timer: 2000
            });
        @endif

        @if (Session::has('error'))
            cuteToast({
                type: "error",
                message: "{{ session('error') }}",
                img: errorAlertImage,
                timer: 2000
            });
        @endif
        @if ($errors->any())
            var myModal = new bootstrap.Modal(document.getElementById("staticBackdrop"), {});
            document.onreadystatechange = function() {
                myModal.show();
            };
        @endif
    </script>
    
</body>
</html>