@extends('backend.layouts.master')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/css/codemirror.css') }}">
    <script src="{{ asset('backend/js/codemirror.js') }}"></script>
    <script src="{{ asset('backend/js/codemirror_javascript.js') }}"></script>
@endpush

@section('content')
    <div class="page-title2">
        <img src="{{ asset('uploads/favicon.svg') }}" class="title-logo" alt="logo">
        <h5>{{ translate('Frontend Settings') }}</h5>
    </div>
    <form action="{{ route('dashboard.frontend.settings.store') }}" method="post" enctype="multipart/form-data">
        @csrf
        <div class="tab-area settings-area">
            <div class="nav flex-row jusify-content-start nav-pills" id="v-pills-tab" role="tablist"
                aria-orientation="vertical">
                <button class="nav-link active" id="v-pills-general-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-general" type="button" role="tab" aria-controls="v-pills-general"
                    aria-selected="true">{{ translate('General') }}</button>

                <button class="nav-link" id="v-pills-social-media-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-social-media" type="button" role="tab"
                    aria-controls="v-pills-social-media" aria-selected="true">{{ translate('Social Media') }}</button>

                <button class="nav-link" id="v-pills-footer-bottom-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-footer-bottom" type="button" role="tab"
                    aria-controls="v-pills-footer-bottom" aria-selected="true">{{ translate('Footer') }}</button>
                <button class="nav-link" id="v-pills-basic-seo-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-basic-seo" type="button" role="tab" aria-controls="v-pills-basic-seo"
                    aria-selected="true">{{ translate('SEO') }}</button>
                <button class="nav-link" id="v-pills-google-analytics-tab" data-bs-toggle="pill"
                    data-bs-target="#v-pills-google-analytics" type="button" role="tab"
                    aria-controls="v-pills-google-analytics"
                    aria-selected="true">{{ translate('Google Analytics') }}</button>

                <button class="nav-link" id="v-pills-gdpr-tab" data-bs-toggle="pill" data-bs-target="#v-pills-gdpr"
                    type="button" role="tab" aria-controls="v-pills-gdpr"
                    aria-selected="true">{{ translate('GDPR Cookie') }}</button>


                {{-- <button class="nav-link" id="v-pills-css-js-tab" data-bs-toggle="pill" data-bs-target="#v-pills-css-js"
                    type="button" role="tab" aria-controls="v-pills-css-js"
                    aria-selected="true">{{ translate('Custom CSS/JS') }}</button> --}}
            </div>
            <div class="tab-content" id="v-pills-tabContent">
                <div class="tab-pane fade show active p-0" id="v-pills-general" role="tabpanel"
                    aria-labelledby="v-pills-general-tab">
                    <!-- temparory content -->
                    <div class="eg-card product-card">
                        <div class="row">
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Main Logo') }}</label>
                                    <input type="file" class="form-control" name="main_logo"
                                        placeholder="{{ translate('Main Logo') }}">
                                    @if (get_setting('main_logo'))
                                        <img class="mt-2" src="{{ uploaded_asset(get_setting('main_logo')) }}"
                                            alt="Main Logo" width="100">
                                    @endif
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('White Logo') }}</label>
                                    <input type="file" class="form-control" name="white_logo"
                                        placeholder="{{ translate('White Logo') }}">
                                    @if (get_setting('white_logo'))
                                        <img class="mt-2 border bg-dark"
                                            src="{{ uploaded_asset(get_setting('white_logo')) }}" alt="White Logo"
                                            width="100">
                                    @endif
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Favicon') }}</label>
                                    <input type="file" class="form-control" name="front_favicon"
                                        placeholder="{{ translate('Favicon') }}">
                                    @if (get_setting('front_favicon'))
                                        <img class="mt-2" src="{{ uploaded_asset(get_setting('front_favicon')) }}"
                                            alt="Favicon" width="50">
                                    @endif
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Terms & Condition Page URL') }}</label>
                                    <input type="text" class="form-control" name="term_page" value="{{get_setting('term_page')}}"
                                        placeholder="{{ translate('Terms & Condition Page URL') }}">
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Privacy Policy Page URL') }}</label>
                                    <input type="text" class="form-control" name="privacy_page" value="{{get_setting('privacy_page')}}"
                                        placeholder="{{ translate('Privacy Policy Page URL') }}">
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Artist Portfolio URL') }}</label>
                                    <input type="text" class="form-control" name="artist_portfolio_page" value="{{get_setting('artist_portfolio_page')}}"
                                        placeholder="{{ translate('Artist Portfolio URL') }}">
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Artist Page URL') }}</label>
                                    <input type="text" class="form-control" name="artist_page" value="{{get_setting('artist_page')}}"
                                        placeholder="{{ translate('Artist Page URL') }}">
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Category Page URL') }}</label>
                                    <input type="text" class="form-control" name="category_page" value="{{get_setting('category_page')}}"
                                        placeholder="{{ translate('Category Page URL') }}">
                                </div>
                            </div>

                        </div>


                    </div>
                </div>
                <div class="tab-pane fade p-0" id="v-pills-social-media" role="tabpanel"
                    aria-labelledby="v-pills-social-media-tab">
                    <div class="eg-card product-card">
                        <div class="row">

                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Facebook Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('facebook_link', get_setting('facebook_link')) }}"
                                        name="facebook_link" placeholder="{{ translate('Facebook Link') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Twitter X Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('x_link', get_setting('x_link')) }}"
                                        name="x_link" placeholder="{{ translate('Twitter X Link') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Linkedin Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('linkedin_link', get_setting('linkedin_link')) }}"
                                        name="linkedin_link" placeholder="{{ translate('Linkedin Link') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Youtube Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('youtube_link', get_setting('youtube_link')) }}"
                                        name="youtube_link" placeholder="{{ translate('Youtube Link') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Instagram Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('instagram_link', get_setting('instagram_link')) }}"
                                        name="instagram_link" placeholder="{{ translate('Instagram Link') }}">
                                </div>
                            </div>
                            <div class="col-xl-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Pinterest Link') }}</label>
                                    <input type="text" class="form-control"
                                        value="{{ old('pinterest_link', get_setting('pinterest_link')) }}"
                                        name="pinterest_link" placeholder="{{ translate('Pinterest Link') }}">
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="tab-pane fade p-0" id="v-pills-footer-bottom" role="tabpanel"
                    aria-labelledby="v-pills-footer-bottom-tab">
                    <div class="eg-card product-card">
                        <div class="row">
                            <div class="col-xl-6 mb-3">
                                <h6><b>{{ translate('Footer Description') }}</b></h6>
                                <div class="card mt-3 mb-3">
                                    <div class="card-body">
                                        <div class="col-xl-12">
                                            <div class="row mt-3 mb-3">
                                                <div class="col-sm-12">
                                                    <!-- Bool Switch -->
                                                    <div class="bool-switch">
                                                        <input type="checkbox" class="status_id" id="status_id1" value="1"
                                                            name="footer1_status" data-switch="bool"
                                                            {{ get_setting('footer1_status') == 1 ? 'checked' : '' }}>
                                                        <label for="status_id1" data-on-label="On"
                                                            data-off-label="Off"></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-inner mb-35">
                                                <label>{{ translate('Footer Logo') }}</label>
                                                <input type="file" class="form-control" name="footer_logo"
                                                    placeholder="{{ translate('Footer Logo') }}">
                                                @if (get_setting('footer_logo'))
                                                    <img class="mt-2 bg-dark"
                                                        src="{{ asset('uploads/files/' . get_setting('footer_logo')) }}"
                                                        alt="Footer Logo" width="100">
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Description') }}
                                                {{ strtoupper(active_language()) }}</label>
                                            <textarea class="form-control" rows="5" name="footer_desc_{{ active_language() }}"
                                                placeholder="{{ translate('Footer Description') }}">{{ get_setting('footer_desc_' . active_language()) }}</textarea>
                                        </div>


                                    </div>
                                </div>
                                <h6><b>{{ translate('Footer Menu 1') }}</b></h6>
                                <div class="card mt-3">
                                    <div class="card-body">
                                        <div class="row mt-3 mb-3">
                                            <div class="col-sm-12">
                                                <!-- Bool Switch -->
                                                <div class="bool-switch">
                                                    <input type="checkbox" class="status_id" id="status_id2" value="1"
                                                        name="footer2_status" data-switch="bool"
                                                        {{ get_setting('footer2_status') == 1 ? 'checked' : '' }}>
                                                    <label for="status_id2" data-on-label="On"
                                                        data-off-label="Off"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Title') }}</label>
                                            <input type="text" name="footer1_title"
                                                value="{{ old('footer1_title', get_setting('footer1_title')) }}">
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col-xl-6 mb-3">


                                <h6 class="mt-3"><b>{{ translate('Footer Menu 2') }}</b></h6>
                                <div class="card mt-3">
                                    <div class="card-body">
                                        <div class="row mt-3 mb-3">
                                            <div class="col-sm-12">
                                                <!-- Bool Switch -->
                                                <div class="bool-switch">
                                                    <input type="checkbox" class="status_id" id="status_id3" value="1"
                                                        name="footer3_status" data-switch="bool"
                                                        {{ get_setting('footer3_status') == 1 ? 'checked' : '' }}>
                                                    <label for="status_id3" data-on-label="On"
                                                        data-off-label="Off"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Title') }}</label>
                                            <input type="text" name="footer2_title"
                                                value="{{ old('footer2_title', get_setting('footer2_title')) }}">
                                        </div>
                                    </div>
                                </div>

                                <h6 class="mt-3"><b>{{ translate('Footer 4') }}</b></h6>
                                <div class="card mt-3">
                                    <div class="card-body">
                                        <div class="row mt-3 mb-3">
                                            <div class="col-sm-12">
                                                <!-- Bool Switch -->
                                                <div class="bool-switch">
                                                    <input type="checkbox" class="status_id" id="status_id4" value="1"
                                                        name="footer4_status" data-switch="bool"
                                                        {{ get_setting('footer4_status') == 1 ? 'checked' : '' }}>
                                                    <label for="status_id4" data-on-label="On"
                                                        data-off-label="Off"></label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="form-inner mb-35">
                                                    <label>{{ translate('Newsletter Title') }}</label>
                                                    <input type="text" name="newsletter_title"
                                                        value="{{ old('newsletter_title', get_setting('newsletter_title')) }}">
                                                </div>
                                            </div>
                                            <div class="col-xl-12">
                                                <div class="form-inner mb-35">
                                                    <label>{{ translate('Mailchimp API Key') }}</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ old('MAILCHIMP_API_KEY', get_setting('MAILCHIMP_API_KEY')) }}"
                                                        name="MAILCHIMP_API_KEY"
                                                        placeholder="{{ translate('Mailchimp API Key') }}">
                                                </div>
                                            </div>
                                            <div class="col-xl-12">
                                                <div class="form-inner mb-35">
                                                    <label>{{ translate('Mailchimp List ID') }}</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ old('MAILCHIMP_LIST_ID', get_setting('MAILCHIMP_LIST_ID')) }}"
                                                        name="MAILCHIMP_LIST_ID"
                                                        placeholder="{{ translate('Mailchimp List ID') }}">
                                                </div>
                                            </div>


                                            <div class="row mb-3">
                                                <label class="col-sm-8"><b>
                                                        {{ translate('Mailchimp Enabled/Disabled') }}</b></label>

                                                <div class="col-sm-4">
                                                    <!-- Bool Switch -->
                                                    <div class="bool-switch">
                                                        <input type="checkbox" class="status_id"
                                                            id="footer_mailchimp_status" name="footer_mailchimp_status" value="1"
                                                            data-switch="bool"
                                                            {{ get_setting('footer_mailchimp_status') == 1 ? 'checked' : '' }}>
                                                        <label for="footer_mailchimp_status" data-on-label="On"
                                                            data-off-label="Off"></label>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="col-xl-12">
                                                <div class="form-inner mb-35">
                                                    <label>{{ translate('Payment Method Title') }}</label>
                                                    <input type="text" class="form-control"
                                                        name="payment_method_title" value="{{ old('payment_method_title', get_setting('payment_method_title')) }}"
                                                        placeholder="{{ translate('Payment Method Title') }}">
                                                </div>
                                                <div class="form-inner mb-35">
                                                    <label>{{ translate('Payment Method Image') }}</label>
                                                    <input type="file" class="form-control" name="payment_method_img"
                                                        placeholder="{{ translate('Payment Method') }}">
                                                    @if (get_setting('payment_method_img'))
                                                        <img class="mt-2" src="{{ asset('uploads/files/' . get_setting('payment_method_img')) }}"
                                                            width="250">
                                                    @endif
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">

                            <div class="col-xl-12">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Footer Copyright') }}
                                                {{ strtoupper(active_language()) }} </label>
                                            <textarea class="form-control summernote" name="front_copyright_{{ active_language() }}">{{ clean(get_setting('front_copyright_' . active_language())) }}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-6"><b>
                                        {{ translate('Footer Bottom Menu Enabled/Disabled') }}</b></label>

                                <div class="col-sm-6">
                                    <!-- Bool Switch -->
                                    <div class="bool-switch">
                                        <input type="checkbox" class="status_id" id="footer_bottom_menu"
                                            name="footer_bottom_menu" value="1" data-switch="bool"
                                            {{ get_setting('footer_bottom_menu') == 1 ? 'checked' : '' }}>
                                        <label for="footer_bottom_menu" data-on-label="On" data-off-label="Off"></label>
                                    </div>
                                </div>

                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-6"><b>
                                        {{ translate('Footer Bottom Enabled/Disabled') }}</b></label>

                                <div class="col-sm-6">
                                    <!-- Bool Switch -->
                                    <div class="bool-switch">
                                        <input type="checkbox" value="1" class="status_id" id="footer_bottom" name="footer_bottom"
                                            data-switch="bool" {{ get_setting('footer_bottom') == 1 ? 'checked' : '' }}>
                                        <label for="footer_bottom" data-on-label="On" data-off-label="Off"></label>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
                <div class="tab-pane fade p-0" id="v-pills-basic-seo" role="tabpanel"
                    aria-labelledby="v-pills-basic-seo-tab">

                    <div class="eg-card product-card">
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Meta Image') }}</label>
                                    <input type="file" class="form-control" name="meta_img"
                                        placeholder="{{ translate('Upload Meta Image') }}">
                                    @if (get_setting('meta_img'))
                                        <img class="mt-2" src="{{ uploaded_asset(get_setting('meta_img')) }}"
                                            alt="meta image" width="200">
                                    @endif
                                </div>

                            </div>
                            <div class="col-sm-4">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Meta Title') }}</label>
                                    <input type="text" class="form-control" name="meta_title"
                                        value="{{ old('meta_title', get_setting('meta_title')) }}"
                                        placeholder="{{ translate('Enter Meta Title') }}">
                                </div>
                            </div>

                            <div class="col-sm-8">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Meta Keyward') }}</label>
                                    <input type="text" name="meta_keyward"
                                        value="{{ old('meta_keyward', get_setting('meta_keyward')) }}"
                                        data-role="tagsinput" placeholder="{{ translate('Enter Meta Keyward') }}">
                                </div>
                            </div>
                            <div class="form-inner mb-35">
                                <label>{{ translate('Meta Description') }}</label>
                                <textarea class="form-control summernote" rows="5" name="meta_description"
                                    placeholder="{{ translate('Enter Meta Description') }}">{{ clean(get_setting('meta_description')) }}</textarea>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="tab-pane fade p-0" id="v-pills-gdpr" role="tabpanel" aria-labelledby="v-pills-gdpr-tab">

                    <div class="eg-card product-card">
                        <div class="row">
                            <div class="col-xl-4 mb-35">
                                <div class="row">
                                    <label class="col-sm-2"><b>{{ translate('Enabled/Disabled') }}</b></label>
                                    <div class="form-check form-switch col-sm-10">
                                        <input class="form-check-input" value="1" name="gdpr_cookie_enabled"
                                            {{ get_setting('gdpr_cookie_enabled') == 1 ? 'checked' : '' }}
                                            type="checkbox">
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Cookie Title') }}
                                                {{ strtoupper(active_language()) }}</label>
                                            <input type="text" class="form-control"
                                                name="gdpr_title_{{ active_language() }}"
                                                value="{{ get_setting('gdpr_title_' . active_language()) }}"
                                                placeholder="{{ translate('Cookie Title') }}">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Description') }} {{ strtoupper(active_language()) }}
                                            </label>
                                            <textarea name="gdpr_description_{{ active_language() }}" class="summernote">{{ clean(get_setting('gdpr_description_' . active_language())) }}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                </div>
                <div class="tab-pane fade p-0" id="v-pills-google-analytics" role="tabpanel"
                    aria-labelledby="v-pills-google-analytics-tab">

                    <div class="eg-card product-card">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Measurement ID / Tracking ID') }}</label>
                                    <input type="text" class="form-control" name="analytics_id"
                                        value="{{ old('analytics_id', get_setting('analytics_id')) }}"
                                        placeholder="{{ translate('Measurement ID / Tracking ID') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="tab-pane fade p-0" id="v-pills-css-js" role="tabpanel" aria-labelledby="v-pills-css-js-tab">

                    <div class="eg-card product-card">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('CSS') }}</label>
                                    <textarea class="form-control editorContainer" rows="10" name="custom_css"
                                        placeholder="{{ translate('Custom CSS') }}">{{ old('custom_css', get_setting('custom_css')) }}</textarea>
                                </div>
                                <div class="form-inner mb-35">
                                    <label>{{ translate('JS') }}</label>
                                    <textarea class="form-control editorContainer" rows="10" name="custom_js"
                                        placeholder="{{ translate('Custom JS') }}">{{ old('custom_js', get_setting('custom_js')) }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12 text-center">
                <div class="button-group mt-15">
                    <input type="submit" class="eg-btn btn--green medium-btn me-3" value="{{ 'Update' }}">
                </div>
            </div>
        </div>
    </form>
@endsection
