@extends('backend.layouts.master')
@section('content')
<style>
    .select2-container {
        z-index: 9999;
    }

</style>
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>

        <form action="" method="get">
            <div class="input-with-btn d-flex jusify-content-start align-items-strech">
                <input type="text" name="search" placeholder="Contact Name & Email...">
                <button type="submit"><i class="bi bi-search"></i></button>
            </div>
        </form>

    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="table-wrapper">
            <table class="eg-table">
                <thead>
                    <tr>
                        <th>{{ translate('S.N') }}</th>
                        <th>{{ translate('Name') }}</th>
                        <th>{{ translate('Email') }}</th>
                        <th>{{ translate('Option') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @if($contacts->count() > 0)
                    @foreach ($contacts as $key => $contact)
                    <tr class="{{$contact->isRead == 2 ? 'text-bg-warning' : ''}}">
                        <td data-label="S.N">
                            {{ ($contacts->currentpage() - 1) * $contacts->perpage() + $key + 1 }}</td>
                        <td data-label="Name">{{ $contact->name }}</td>
                        <td data-label="Email">{{ $contact->email }}</td>
                        <td data-label="Option">
                            <div class="d-flex flex-row justify-content-md-center justify-content-end align-items-center gap-2">
                                <a class="eg-btn add--btn" href="{{ route('dashboard.contacts.show', $contact->id) }}"><i class="bi bi-eye"></i></a>
                                <form method="POST" action="{{ route('dashboard.contacts.destroy', $contact->id) }}">
                                    @csrf
                                    <input name="_method" type="hidden" value="DELETE">
                                    <button type="submit" class="eg-btn delete--btn show_confirm" data-toggle="tooltip" title='Delete'><i class="bi bi-trash"></i></button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                    @else
                    <tr>
                        <td colspan="4">
                            <h5 class="text-center">{{translate('Data not found')}}</h5>
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('footer')
<div class="d-flex justify-content-center custom-pagination">
    {!! $contacts->links() !!}
</div>
@endpush
@endsection
