@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
        <div class="language-changer">
            <span>{{ translate('Language Translation') }}: </span>
            @foreach (\App\Models\Language::all() as $key => $language)
            @if ($lang == $language->code)
            <img src="{{ asset('flags/' . $language->code . '.png') }}" class="mr-3" height="16">
            @else
            <a href="{{ route('dashboard.artwork.categories.edit', ['id' => $artworkSingle->id, 'lang' => $language->code]) }}"><img src="{{ asset('flags/' . $language->code . '.png') }}" class="mr-3" height="16"></a>
            @endif
            @endforeach
        </div>
        <a href="{{ route('dashboard.artworks.index') }}" class="eg-btn btn--primary back-btn"> <img src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
            {{ translate('Go Back') }}</a>
    </div>
</div>
<form action="{{ route('dashboard.artworks.update', $artworkSingle->id) }}" method="post" enctype="multipart/form-data">
    @method('PATCH')
    @csrf
    <input type="hidden" name="lang" value="{{ $lang }}">
    <div class="row">
        <div class="col-lg-7">
            <div class="eg-card product-card">
                <div class="form-inner mb-35">
                    <label>{{ translate('Name') }} <span class="text-danger">*</span></label>
                    <input type="text" class="username-input" value="{{ old('name', $artworkSingle->getTranslation('name')) }}" name="name" placeholder="{{ translate('Enter Name') }}">
                    @error('name')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-inner mb-25">
                    <label>{{ translate('Content') }} <span class="text-danger">*</span></label>
                    <textarea class="summernote" name="content">{{ old('content', $artworkSingle->getTranslation('content')) }}</textarea>
                    @error('content')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-inner mb-25">
                    <label>{{ translate('Tags') }}</label>
                    <input type="text" name="tags" value="{{ old('tags',$artworkSingle->getTranslation('tags')) }}" data-role="tagsinput" placeholder="{{ translate('Enter Tag') }}">
                    @error('tags')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="form-inner mb-2">
                            <label>{{ translate('Size') }}</label>
                        </div>
                    </div>

                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="height" placeholder="{{ translate('Height') }}" aria-label="Height" aria-describedby="height" value="{{ old('height', $artworkSingle->height) }}">
                                <span class="input-group-text" id="height">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="width" value="{{ old('width', $artworkSingle->width) }}" placeholder="{{ translate('Width') }}" aria-label="Width" aria-describedby="width">
                                <span class="input-group-text" id="width">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="length" value="{{ old('length', $artworkSingle->length) }}" placeholder="{{ translate('Length') }}" aria-label="Length" aria-describedby="length">
                                <span class="input-group-text" id="length">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Year') }}</label>
                            <select class="select2" id="year" name="year">
                                <option value="">{{ translate('Select Option') }}</option>
                                <option value="{{ $artworkSingle->year }}" selected>{{ $artworkSingle->year }}
                                </option>
                            </select>
                            @error('year')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Location') }}</label>
                            <input type="text" name="location" value="{{ old('location', $artworkSingle->location) }}" placeholder="{{ translate('Location') }}">
                            @error('location')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Condition') }} <span class="text-danger">*</span></label>
                            <select class="select2" name="condition" required>
                                <option value="">{{ translate('Select Option') }}</option>
                                <option value="1" {{ $artworkSingle->condition == 1 ? 'selected' : '' }}>
                                    {{ translate('Good') }}</option>
                                <option value="2" {{ $artworkSingle->condition == 2 ? 'selected' : '' }}>
                                    {{ translate('Bad') }}</option>
                                <option value="3" {{ $artworkSingle->condition == 3 ? 'selected' : '' }}>
                                    {{ translate('Moderate') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Certificate Number') }} </label>
                            <input type="text" class="username-input"
                                value="{{ old('certificate_number', $artworkSingle->certificate_number) }}" name="certificate_number"
                                placeholder="{{ translate('Enter Certificate Number') }}">
                            @error('certificate_number')
                                <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Reference Number') }} </label>
                            <input type="text" class="username-input" value="{{ old('reference_number', $artworkSingle->reference_number) }}" name="reference_number" placeholder="{{ translate('Enter Reference Number') }}">
                            @error('reference_number')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-inner">
                    <div class="row">
                        <div class="col-md-6">
                            <label> <b>{{ translate('Specifications') }}</b></label>
                        </div>
                    </div>
                </div>
                <div class="mb-35 text-center">
                    <div class="g-4" id="specifiction_artwork">

                        @php
                        $specData = $artworkSingle->getTranslation('specifications');
                        $specifications = $specData ? json_decode($specData) : [];
                        @endphp
                        @if (!empty($specifications))
                        @foreach ($specifications as $specification)
                        <div class="mb-3 row g-3 specificationRow">
                            <div class="form-inner col-md-6">
                                <input type="text" value="{{ $specification->label }}" name="specifications[${specification}][label]" class="m-input" placeholder="Label" autocomplete="off">
                            </div>
                            <div class="form-inner col-md-6 d-flex justify-content-center gap-2">
                                <input type="text" value="{{ $specification->value }}" name="specifications[${specification}][value]" class=" n-input" placeholder="Value" autocomplete="off">
                                <button type="button" class="removeRow eg-btn btn--red rounded px-3">
                                    <i class="bi bi-x"></i></button>
                            </div>
                            <div class="input-group-append">
                            </div>
                        </div>
                        @endforeach
                        @endif
                    </div>
                    <input type="button" value="{{ translate('Add New') }}" class="eg-btn btn--primary submit--btn mt-15 addSpecification">
                </div>
                <div class="row mt-3">
                    <div class="col-xl-12">
                        <div class="form-check">
                            <label class="form-check-label" for="seoProduct">
                                <input class="form-check-input seo-page-checkbox" name="enable_seo" type="checkbox" id="seoProduct" {{ $artworkSingle->enable_seo == 1 ? 'checked' : '' }}>
                                <b>{{ translate('Allow SEO') }}</b>
                            </label>
                        </div>
                    </div>

                    <div class="row mt-3 seo-content">
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Title') }} <span class="text-danger">*</span></label>
                                <input type="text" class="username-input" value="{{ old('meta_title', $artworkSingle->meta_title) }}" name="meta_title" placeholder="{{ translate('Enter Meta Title') }}">
                            </div>
                        </div>


                        <div class="form-inner mb-25">
                            <label>{{ translate('Meta Keyward') }}</label>
                            <input type="text" name="meta_keyward" value="{{ old('meta_keyward', $artworkSingle->meta_keyward) }}" data-role="tagsinput" placeholder="{{ translate('Enter Meta Keyward') }}">
                            @error('meta_keyward')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Description') }}</label>
                                <textarea name="meta_description" placeholder="{{ translate('Enter Meta Description') }}">{{ old('meta_description', $artworkSingle->meta_description) }}</textarea>
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Image') }}</label>
                                <input type="file" name="meta_image">
                                @if ($artworkSingle->meta_image)
                                <img class="mt-2" src="{{ uploaded_asset($artworkSingle->meta_image) }}" alt="{{ $artworkSingle->meta_title }}" width="100">
                                @endif
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="eg-card product-card">
                <div class="row">
                    <div class="col-12">
                        <div class="form-inner file-upload mb-35">
                            <label class="control-label">{{ translate('Feature Image') }} <span class="text-danger">*</span></label>
                            <div class="dropzone-wrapper">
                                <div class="dropzone-desc">
                                    <i class="glyphicon glyphicon-download-alt"></i>
                                    <p>{{ translate('Choose an image file or drag it here') }}</p>
                                </div>
                                <input type="file" name="features_image" class="dropzone featues_image">
                            </div>


                            <div class="preview-zone hidden mt-3 text-center">
                                <div class="box box-solid">
                                    <div class="box-header with-border">
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-danger btn-xs remove-preview" style="display:none;">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        @if ($artworkSingle->features_image)
                                        <img src="{{ uploaded_asset($artworkSingle->features_image) }}" alt="{{ $artworkSingle->name }}" width="100">
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        @error('features_image')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <div class="form-inner img-upload mb-35">

                            <label class="control-label">{{ translate('Image Gallery') }}</label>

                            <div class="dropzone-wrapper">
                                <div class="dropzone-desc">
                                    <i class="glyphicon glyphicon-download-alt"></i>
                                    <p>{{ translate('Choose image files or drag it here') }}</p>
                                </div>
                                <input type="file" id="files" name="image[]" class="dropzone image_gal" multiple>

                            </div>

                            <div class="gallery-preview-zone hidden">
                                <div class="box box-solid">
                                    <div class="box-body">
                                        @if ($artworkSingle->galleries?->count() > 0)
                                        @foreach ($artworkSingle->galleries as $gallery)
                                        <div class="img-thumb-wrapper card shadow" id="gallery{{ $gallery->id }}">
                                            <span class="exist_remove" data-gellery_id="{{ $gallery->id }}">X</span>
                                            <img class="img-thumb" src="{{ uploaded_asset($gallery->image) }}" title="{{ $gallery->image }}">
                                        </div>
                                        @endforeach
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        @error('image')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12">
                        <div class="mb-35">
                            <label class="mb-2">{{ translate('Category') }} <span class="text-danger">*</span></label>
                            @php
                            $selectedCategories = $artworkSingle->categories->pluck('id')->toArray();
                            @endphp
                            @foreach ($categories as $category)
                            <div class="form-check ms-2">
                                <label class="form-check-label" for="term{{ $category->id }}">
                                    <input class="form-check-input" name="category_id[]" type="checkbox" id="term{{ $category->id }}" value="{{ $category->id }}" {{ in_array($category->id, $selectedCategories) ? 'checked' : '' }}>
                                    <b>{{ $category->getTranslation('name') }}</b>
                                </label>
                            </div>
                            @endforeach

                            @error('category_id')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Quantity') }} <span class="text-danger">*</span></label>
                            <input type="number" name="quantity" value="{{ old('quantity', $artworkSingle->quantity) }}">
                            @error('quantity')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Type') }} <span class="text-danger">*</span></label>
                            <select class="select2 auction_type_select" name="sale_type">
                                <option selected disabled>{{ translate('Select Option') }}</option>
                                <option value="1" {{ $artworkSingle->sale_type == 1 ? 'selected' : '' }}>
                                    {{ 'Auction Sale' }}</option>
                                <option value="2" {{ $artworkSingle->sale_type == 2 ? 'selected' : '' }}>
                                    {{ 'Direct Sale' }}</option>
                            </select>
                            @error('sale_type')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror

                        </div>
                    </div>
                    <div class="col-12 pricing-area-schedule" style="display: block;">
                        <div class="row">
                            <div class="col-xl-12 auction_type" @if ($artworkSingle->sale_type == 1) style="display: block;" @endif>
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Minimum Deposit') }}</label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="min_deposit" value="{{ old('min_deposit', $artworkSingle->min_deposit) }}">
                                        <select class="select2" name="min_deposit_type">
                                            <option value="1" {{ old('min_deposit_type', $artworkSingle->min_deposit_type) == 1 ? 'selected' : '' }}>
                                                {{ 'Percent' }}</option>
                                            <option value="2" {{ old('min_deposit_type', $artworkSingle->min_deposit_type) == 2 ? 'selected' : '' }}>
                                                {{ 'Fixed' }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 direct_type" @if ($artworkSingle->sale_type == 2) style="display: block;" @endif>
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Regular Price') }} </label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" class="price" name="price" value="{{ old('price', $artworkSingle->price) }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 direct_type" @if ($artworkSingle->sale_type == 2) style="display: block;" @endif>
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Sale Price') }} </label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="sale_price" value="{{ old('sale_price', $artworkSingle->sale_price) }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12 auction_type" @if ($artworkSingle->sale_type == 1) style="display: block;" @endif>
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Minimum Bid Price') }} <span class="text-danger">*</span></label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="min_bid_price" value="{{ old('min_bid_price', $artworkSingle->min_bid_price) }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 auction_schedule">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Schedule') }} <span class="text-danger">*</span></label>
                                    <select class="select2 auction_schedule_type" name="schedule_type">
                                        <option value="">{{ translate('Select Option') }}</option>
                                        <option value="1" {{ old('schedule_type', $artworkSingle->schedule_type) == 1 ? 'selected' : '' }} selected>
                                            {{ 'Yes' }}</option>
                                        <option value="2" {{ old('schedule_type', $artworkSingle->schedule_type) == 2 ? 'selected' : '' }}>
                                            {{ 'No' }}</option>
                                    </select>
                                    @error('schedule_type')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-12 schedule_start_date auction_type">
                                <div class="form-inner mb-35 position-relative">
                                    <label>{{ translate('Start Date') }} <span class="text-danger">*</span></label>
                                    <input id="datepicker" name="start_date" placeholder="Select Date & Time" value="{{ old('start_date', $artworkSingle->start_date) }}">
                                    <img src="{{ asset('backend/images/icons/calendar2.svg') }}" class="datepicker-icon" alt="Calender">
                                </div>
                            </div>
                            <div class="col-xl-12 auction_type">
                                <div class="form-inner mb-35 position-relative">
                                    <label>{{ translate('End Date') }} <span class="text-danger">*</span></label>
                                    <input id="datepicker2" name="end_date" placeholder="Select Date & Time" value="{{ old('end_date', $artworkSingle->end_date) }}">
                                    <img src="{{ asset('backend/images/icons/calendar2.svg') }}" class="datepicker-icon" alt="Calender">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-center">
                        <div class="button-group mt-15">
                            <button type="submit" class="radio-button">
                                <input type="radio" id="status1" name="status" value="1">
                                <label class="eg-btn btn--green medium-btn" for="status1">{{ translate('Published') }}</label>
                            </button>
                            <button type="submit" class="radio-button">
                                <input type="radio" id="status2" name="status" value="2">
                                <label class="eg-btn btn--primary medium-btn" for="status2">{{ translate('Draft') }}</label>
                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</form>
@endsection
