@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
        <a href="{{ route('dashboard.artworks.index') }}" class="eg-btn btn--primary back-btn"> <img src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
            {{ translate('Go Back') }}</a>
    </div>
</div>
<form action="{{ route('dashboard.artworks.store') }}" method="post" id="artwork" enctype="multipart/form-data">
    @csrf
    <div class="row">
        <div class="col-lg-7">
            <div class="eg-card product-card">
                <div class="form-inner mb-35">
                    <label>{{ translate('Name') }} <span class="text-danger">*</span></label>
                    <input required type="text" class="username-input" value="{{ old('name') }}" name="name" placeholder="{{ translate('Enter Name') }}">
                    @error('name')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-inner mb-25">
                    <label>{{ translate('Content') }} <span class="text-danger">*</span></label>
                    <textarea required class="summernote" name="content">{{ old('content') }}</textarea>
                    @error('content')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-inner mb-25">
                    <label>{{ translate('Tags') }}</label>
                    <input type="text" name="tags" value="{{ old('tags') }}" data-role="tagsinput" placeholder="{{ translate('Enter Tag') }}">
                    @error('tags')
                    <div class="error text-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <div class="form-inner mb-2">
                            <label>{{ translate('Size') }}</label>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="height" placeholder="{{ translate('Height') }}" aria-label="Height" aria-describedby="height" value="{{ old('height') }}">
                                <span class="input-group-text" id="height">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="width" placeholder="{{ translate('Width') }}" aria-label="Width" aria-describedby="width" value="{{ old('width') }}">
                                <span class="input-group-text" id="width">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner">
                            <div class="input-group mb-3">
                                <input type="number" min="1" step="0.1" class="form-control" name="length" placeholder="{{ translate('Length') }}" aria-label="Length" aria-describedby="length" value="{{ old('length') }}">
                                <span class="input-group-text" id="length">{{ translate('inch') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Year') }}</label>
                            <select class="select2" id="year" name="year">
                                <option value="">{{ translate('Select Option') }}</option>
                            </select>
                            @error('year')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Location') }}</label>
                            <input type="text" name="location" value="{{ old('location') }}" placeholder="{{ translate('Location') }}">
                            @error('location')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Condition') }} <span class="text-danger">*</span></label>
                            <select class="select2" name="condition" required>
                                <option value="">{{ translate('Select Option') }}</option>
                                <option value="1">{{ translate('Good') }}</option>
                                <option value="2">{{ translate('Bad') }}</option>
                                <option value="3">{{ translate('Moderate') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                    <div class="form-inner mb-35">
                        <label>{{ translate('Reference Number') }} </label>
                        <input  type="text" class="username-input" value="{{ old('reference_number') }}" name="reference_number" placeholder="{{ translate('Enter Reference Number') }}">
                        @error('reference_number')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    </div>
                    <div class="col-6">
                    <div class="form-inner mb-35">
                        <label>{{ translate('Certificate Number') }} </label>
                        <input type="text" class="username-input" value="{{ old('certificate_number') }}" name="certificate_number" placeholder="{{ translate('Enter Certificate Number') }}">
                        @error('certificate_number')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    </div>
                </div>

                <div class="form-inner">
                    <div class="row">
                        <div class="col-md-6">
                            <label> <b>{{ translate('Specifications') }}</b></label>
                        </div>
                    </div>
                </div>
                <div class="mb-35 text-center">
                    <div class="g-4" id="specifiction_artwork">

                    </div>
                    <input type="button" value="{{ translate('Add New') }}" class="eg-btn btn--primary submit--btn mt-15 addSpecification">
                </div>
                <div class="row mt-3">
                    <div class="col-xl-12">
                        <div class="form-check">
                            <label class="form-check-label" for="seoProduct">
                                <input class="form-check-input seo-page-checkbox" name="enable_seo" type="checkbox" id="seoProduct">
                                <b>{{ translate('Allow SEO') }}</b>
                            </label>
                        </div>
                    </div>
                    <div class="row mt-3 seo-content">
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Title') }} <span class="text-danger">*</span></label>
                                <input type="text" class="username-input" value="{{ old('meta_title') }}" name="meta_title" placeholder="{{ translate('Enter Meta Title') }}">
                            </div>
                        </div>
                        <div class="form-inner mb-25">
                            <label>{{ translate('Meta Keyward') }}</label>
                            <input type="text" name="meta_keyward" value="{{ old('meta_keyward') }}" data-role="tagsinput" placeholder="{{ translate('Enter Meta Keyward') }}">
                            @error('meta_keyward')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Description') }}</label>
                                <textarea name="meta_description" placeholder="{{ translate('Enter Meta Description') }}">{{ old('meta_description') }}</textarea>
                            </div>
                        </div>
                        <div class="col-xl-12">
                            <div class="form-inner mb-35">
                                <label> {{ translate('Meta Image') }}</label>
                                <input type="file" name="meta_image">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="eg-card product-card">
                <div class="row">
                    <div class="col-12">
                        <div class="form-inner file-upload mb-35">
                            <label class="control-label">{{ translate('Feature Image') }} <span class="text-danger">*</span></label>
                            <div class="dropzone-wrapper">
                                <div class="dropzone-desc">
                                    <i class="glyphicon glyphicon-download-alt"></i>
                                    <p>{{ translate('Choose an image file or drag it here') }}</p>
                                </div>
                                <input required type="file" name="features_image" class="dropzone featues_image">
                            </div>
                            <div class="preview-zone hidden mt-3 text-center">
                                <div class="box box-solid">
                                    <div class="box-header with-border">
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-danger btn-xs remove-preview" style="display:none;">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="box-body"></div>
                                </div>
                            </div>
                        </div>
                        @error('features_image')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12">
                        <div class="form-inner img-upload mb-35">
                            <label class="control-label">{{ translate('Image Gallery') }}</label>
                            <div class="dropzone-wrapper">
                                <div class="dropzone-desc">
                                    <i class="glyphicon glyphicon-download-alt"></i>
                                    <p>{{ translate('Choose image files or drag it here') }}</p>
                                </div>
                                <input type="file" id="files" name="image[]" class="dropzone image_gal" multiple>
                            </div>
                            <div class="gallery-preview-zone hidden">
                                <div class="box box-solid">
                                    <div class="box-body"></div>
                                </div>
                            </div>
                        </div>
                        @error('image')
                        <div class="error text-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    @admin
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Author') }} <span class="text-danger">*</span></label>
                            <select class="select2 author_id" name="author_id" required>
                                <option value="">{{ translate('Select Option') }}</option>
                                @foreach ($authors as $author)
                                <option value="{{ $author->id }}" {{ old('author_id') == $author->id ? 'selected' : '' }}>
                                    {{ $author->fname . ' ' . $author->lname . ' - ' . $author->custom_id }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    @endadmin
                    @adminOrAgent
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Artist') }} <span class="text-danger">*</span></label>
                            <select class="select2 artist_id" name="artist_id" required>
                                <option value="">{{ translate('Select Option') }}</option>
                                @agent
                                @foreach ($authors as $author)
                                <option value="{{ $author->id }}" {{ old('artist_id') == $author->id ? 'selected' : '' }}>
                                    {{ $author->name }}
                                </option>
                                @endforeach
                                @endagent
                            </select>
                        </div>
                    </div>
                    @endadminOrAgent
                    <div class="col-12">
                        <div class="mb-35">
                            <label class="mb-2">{{ translate('Category') }} <span class="text-danger">*</span></label>
                            @foreach ($categories as $category)
                            <div class="form-check ms-2">
                                <label class="form-check-label" for="term{{ $category->id }}">
                                    <input class="form-check-input category" required name="category_id[]" type="checkbox" id="term{{ $category->id }}" value="{{ $category->id }}">
                                    <b>{{ $category->getTranslation('name') }}</b>
                                </label>
                            </div>
                            @endforeach
                            @error('category_id')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Quantity') }} <span class="text-danger">*</span></label>
                            <input type="number" name="quantity" value="{{ old('quantity', 1) }}">
                            @error('quantity')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <input type="hidden" id="product_sale_type">
                    <div class="col-12">
                        <div class="form-inner mb-35">
                            <label>{{ translate('Type') }} <span class="text-danger">*</span></label>
                            <select required class="select2 auction_type_select" name="sale_type">
                                <option value="" >{{ translate('Select Option') }}</option>
                                <option value="1"> {{ 'Auction Sale' }}</option>
                                <option value="2"> {{ 'Direct Sale' }}</option>
                            </select>
                            @error('sale_type')
                            <div class="error text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-12 pricing-area-schedule">
                        <div class="row">
                            <div class="col-xl-12 auction_type">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Minimum Deposit') }}</label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="min_deposit" value="{{ old('min_deposit') }}">
                                        <select class="select2" name="min_deposit_type">
                                            <option value="1" {{ old('min_deposit_type') == 1 ? 'selected' : '' }}>
                                                {{ 'Percent' }}</option>
                                            <option value="2" {{ old('min_deposit_type') == 2 ? 'selected' : '' }}>
                                                {{ 'Fixed' }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 direct_type">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Regular Price') }} <span class="text-danger">*</span></label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" class="price" name="price" value="{{ old('price') }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-6 direct_type">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Sale Price') }} </label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="sale_price" value="{{ old('sale_price') }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12 auction_type">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Minimum Bid Price') }} <span class="text-danger">*</span></label>
                                    <div class="input-with-btn style2 d-flex jusify-content-start align-items-strech">
                                        <input type="text" placeholder="0.00" name="min_bid_price" value="{{ old('min_bid_price') }}">
                                        <button type="button">{{ currency_symbol(get_setting('default_currency')) }}</button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 auction_schedule">
                                <div class="form-inner mb-35">
                                    <label>{{ translate('Schedule') }} <span class="text-danger">*</span></label>
                                    <select class="select2 auction_schedule_type" name="schedule_type">
                                        <option value="">{{ translate('Select Option') }}</option>
                                        <option value="1" {{ old('schedule_type') == 1 ? 'selected' : '' }} selected>
                                            {{ 'Yes' }}</option>
                                        <option value="2" {{ old('schedule_type') == 2 ? 'selected' : '' }}>
                                            {{ 'No' }}</option>
                                    </select>
                                    @error('schedule_type')
                                    <div class="error text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-12 auction_type schedule_start_date">
                                <div class="form-inner mb-35 position-relative">
                                    <label>{{ translate('Start Date') }} <span class="text-danger">*</span></label>
                                    <input id="datepicker" name="start_date" placeholder="Select Date & Time" value="{{ old('start_date') }}">
                                    <img src="{{ asset('backend/images/icons/calendar2.svg') }}" class="datepicker-icon" alt="Calender">
                                </div>
                            </div>
                            <div class="col-xl-12 auction_type">
                                <div class="form-inner mb-35 position-relative">
                                    <label>{{ translate('End Date') }} <span class="text-danger">*</span></label>
                                    <input id="datepicker2" name="end_date" placeholder="Select Date & Time" value="{{ old('end_date') }}">
                                    <img src="{{ asset('backend/images/icons/calendar2.svg') }}" class="datepicker-icon" alt="Calender">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-center">
                        <div class="button-group mt-15">
                            <button type="submit" class="radio-button">
                                <input type="radio" id="status1" name="status" value="1">
                                <label class="eg-btn btn--green medium-btn" for="status1">{{ translate('Published') }}</label>
                            </button>
                            <button type="submit" class="radio-button">
                                <input type="radio" id="status2" name="status" value="2">
                                <label class="eg-btn btn--primary medium-btn" for="status2">{{ translate('Draft') }}</label>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@push('js')
<script>
    $(document).ready(function(){
        var checkboxes = $('.category');
        checkboxes.change(function(){
            if($('.category:checked').length>0) {
                checkboxes.removeAttr('required');
            } else {
                checkboxes.attr('required', 'required');
            }
        });
    });
</script>
@endpush
