@extends('backend.layouts.master')
@section('content')
<div class="row mb-35 g-4">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{$page_title ?? ''}}</h4>
    </div>
</div>
<div class="eg-card product-card">
    <form action="{{route('dashboard.profile.payment.update',$user->id)}}" method="post" enctype="multipart/form-data">
        <input name="_method" type="hidden" value="PATCH">
        @csrf
        <h4 class="form-box-title">{{translate('Payment Details')}}</h4>
        <div class="form-box mb-35 text-center">
            <div class="g-4" id="bankDetailsMainContent">
                @if($art_gallery_payment)
                @foreach($art_gallery_payment as $key=>$art_payment)
                @php
                $payment_info = !empty($art_payment->payment_info)
                ? json_decode($art_payment->payment_info, true)
                : [];
                @endphp
                <div class="row payment_info">
                    <div class="col-lg-6">
                        <div class="form-inner mb-35">
                            <input type="hidden" name="art_gallery_payment_id[{{$key}}]" value="{{$art_payment->id}}">
                            <label>{{translate('Type')}} <span class="text-danger">*</span></label>
                            <select class="select2 payment_type" name="payment_type[]">
                                <option value="">{{translate('Select Option')}}</option>
                                <option value="1" {{ $art_payment->payment_type == 1 ? 'selected' : ''
                                    }}>{{translate('Bank')}}</option>
                                <option value="2" {{ $art_payment->payment_type == 2 ? 'selected' : ''
                                    }}>{{translate('Mobile Banking')}}</option>
                                <option value="3" {{ $art_payment->payment_type == 3 ? 'selected' : ''
                                    }}>{{translate('Paypal')}}</option>
                            </select>
                        </div>
                    </div>
                    @if($art_payment->payment_type == 1)
                    <div class="col-lg-6 select_bank">
                        <div class="form-inner mb-35">
                            <label>{{translate('Bank Name')}}</label>
                            <input type="text" class="bank_name" value="{{$payment_info['bank_name'] ?? ''}}" name="bank_name[{{$key}}]" placeholder="{{translate('Enter Bank Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank">
                        <div class="form-inner mb-35">
                            <label>{{translate('Branch Name')}}</label>
                            <input type="text" class="branch_name" value="{{$payment_info['branch_name'] ?? ''}}" name="branch_name[{{$key}}]" placeholder="{{translate('Enter Branch Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank">
                        <div class="form-inner mb-35">
                            <label>{{translate('Bank Account Name')}}</label>
                            <input type="text" class="bank_ac_name" value="{{$payment_info['bank_ac_name'] ?? ''}}" name="bank_ac_name[{{$key}}]" placeholder="{{translate('Enter Bank Account Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank">
                        <div class="form-inner mb-35">
                            <label>{{translate('Bank Account Number')}}</label>
                            <input type="text" name="bank_ac_number[{{$key}}]" value="{{$payment_info['bank_ac_number'] ?? ''}}" class="bank_ac_number username-input" placeholder="{{translate('Enter Bank Account Number')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank">
                        <div class="form-inner mb-35">
                            <label>{{translate('Bank Routing Number')}}</label>
                            <input type="text" class="bank_routing_number" value="{{$payment_info['bank_routing_number'] ?? ''}}" name="bank_routing_number[{{$key}}]" placeholder="{{translate('Enter Bank Routing Number')}}">
                        </div>
                    </div>
                    @elseif($art_payment->payment_type == 2)
                    <div class="col-lg-6 select_mobile">
                        <div class="form-inner mb-35">
                            <label>{{translate('Mobile Banking Name')}}</label>
                            <input type="text" class="mobile_banking_name" value="{{$payment_info['mobile_banking_name'] ?? ''}}" name="mobile_banking_name[{{$key}}]" placeholder="{{translate('Enter Mobile Banking Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_mobile">
                        <div class="form-inner mb-35">
                            <label>{{translate('Mobile Number')}}</label>
                            <input type="text" class="mobile_banking_number" value="{{$payment_info['mobile_banking_number'] ?? ''}}" name="mobile_banking_number[{{$key}}]" placeholder="{{translate('Enter Mobile Number')}}">
                        </div>
                    </div>
                    @elseif($art_payment->payment_type == 3)
                    <div class="col-lg-6 select_paypal">
                        <div class="form-inner mb-35">
                            <label>{{translate('Paypal Name')}}</label>
                            <input type="text" class="paypal_name" value="{{$payment_info['paypal_name'] ?? ''}}" name="paypal_name[{{$key}}]" placeholder="{{translate('Enter Paypal Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal">
                        <div class="form-inner mb-35">
                            <label>{{translate('Paypal Username')}}</label>
                            <input type="text" class="paypal_username" value="{{$payment_info['paypal_username'] ?? ''}}" name="paypal_username[{{$key}}]" placeholder="{{translate('Enter Paypal Username')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal">
                        <div class="form-inner mb-35">
                            <label>{{translate('Paypal Email')}}</label>
                            <input type="email" class="paypal_email" value="{{$payment_info['paypal_email'] ?? ''}}" name="paypal_email[{{$key}}]" placeholder="{{translate('Enter Paypal Email')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal">
                        <div class="form-inner mb-35">
                            <label>{{translate('Paypal Mobile Number')}}</label>
                            <input type="text" class="paypal_mobile_number" value="{{$payment_info['paypal_mobile_number'] ?? ''}}" name="paypal_mobile_number[{{$key}}]" placeholder="{{translate('Enter Paypal Mobile Number')}}">
                        </div>
                    </div>
                    @endif
                    <div class="col-lg-12">
                        <button style="float: right;" type="button" class="removePaymentRow eg-btn btn--red rounded px-3">
                            <i class="bi bi-x"></i>
                        </button>
                    </div>
                </div>
                @endforeach
                @else
                <div class="row payment_info">
                    <div class="col-lg-6">
                        <div class="form-inner">
                            <input type="hidden" name="art_gallery_payment_id[0]" value="">
                            <label>{{translate('Type')}} <span class="text-danger">*</span></label>
                            <select class="select2 payment_type" name="payment_type[0]">
                                <option value="">{{translate('Select Option')}}</option>
                                <option value="1">{{translate('Bank')}}</option>
                                <option value="2">{{translate('Mobile Banking')}}</option>
                                <option value="3">{{translate('Paypal')}}</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank" style="display:none;">
                        <div class="form-inner">
                            <label>{{translate('Bank Name')}}</label>
                            <input type="text" class="bank_name" name="bank_name[0]" placeholder="{{translate('Enter Bank Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank" style="display:none;">
                        <div class="form-inner">
                            <label>{{translate('Branch Name')}}</label>
                            <input type="text" class="branch_name" name="branch_name[0]" placeholder="{{translate('Enter Branch Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank" style="display:none;">
                        <div class="form-inner">
                            <label>{{translate('Bank Account Name')}}</label>
                            <input type="text" class="bank_ac_name" name="bank_ac_name[0]" placeholder="{{translate('Enter Bank Account Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank" style="display:none;">
                        <div class="form-inner">
                            <label>{{translate('Bank Account Number')}}</label>
                            <input type="text" name="bank_ac_number[0]" class="bank_ac_number username-input" placeholder="{{translate('Enter Bank Account Number')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_bank" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Bank Routing Number')}}</label>
                            <input type="text" class="bank_routing_number" name="bank_routing_number[0]" placeholder="{{translate('Enter Bank Routing Number')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_mobile" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Mobile Banking Name')}}</label>
                            <input type="text" class="mobile_banking_name" name="mobile_banking_name[0]" placeholder="{{translate('Enter Mobile Banking Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_mobile" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Mobile Number')}}</label>
                            <input type="text" class="mobile_banking_number" name="mobile_banking_number[0]" placeholder="{{translate('Enter Mobile Number')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Paypal Name')}}</label>
                            <input type="text" class="paypal_name" name="paypal_name[0]" placeholder="{{translate('Enter Paypal Name')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Paypal Username')}}</label>
                            <input type="text" class="paypal_username" name="paypal_username[0]" placeholder="{{translate('Enter Paypal Username')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Paypal Email')}}</label>
                            <input type="email" class="paypal_email" name="paypal_email[0]" placeholder="{{translate('Enter Paypal Email')}}">
                        </div>
                    </div>
                    <div class="col-lg-6 select_paypal" style="display:none;">
                        <div class="form-inner mb-35 ">
                            <label>{{translate('Paypal Mobile Number')}}</label>
                            <input type="text" class="paypal_mobile_number" name="paypal_mobile_number[0]" placeholder="{{translate('Enter Paypal Mobile Number')}}">
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <button style="float: right;" type="button" class="removePaymentRow eg-btn btn--red rounded px-3">
                            <i class="bi bi-x"></i>
                        </button>
                    </div>
                </div>
                @endif
            </div>
            <input type="button" value="{{translate('Add Another Account')}}" class="eg-btn btn--primary submit--btn mt-15 addPayment">
        </div>
        <div class="button-group mt-15 text-end">
            <input type="submit" class="eg-btn btn--green medium-btn me-3" value="{{ translate('Update') }}">
            <button type="button" class="eg-btn btn--red cancel-btn" onClick="window.location.reload()">{{
                translate('Cancel') }}</button>
        </div>
    </form>
</div>
@endsection