@extends('backend.layouts.master')
@section('content')
<div class="row mb-35">
    <div class="page-title d-flex justify-content-between align-items-center">
        <h4>{{ $page_title ?? '' }}</h4>
        <div class="language-changer">
            <span>{{ translate('Language Translation') }}: </span>
            @foreach (\App\Models\Language::all() as $key => $language)
            @if ($lang == $language->code)
            <img src="{{ asset('flags/' . $language->code . '.png') }}" class="mr-3" height="16">
            @else
            <a href="{{ route('dashboard.artist.edit', ['id' => $artistSingle->id, 'lang' => $language->code]) }}"><img
                    src="{{ asset('flags/' . $language->code . '.png') }}" class="mr-3" height="16"></a>
            @endif
            @endforeach
        </div>
        @if(Auth::user()->role != 1)
        <a href="{{ route('dashboard.artist.index') }}" class="eg-btn btn--primary back-btn"> <img
                src="{{ asset('backend/images/icons/back.svg') }}" alt="{{ translate('Go Back') }}">
            {{ translate('Go Back') }}</a>
        @endif
    </div>
</div>
<form action="{{ route('dashboard.artist.update', $artistSingle->id) }}" method="post" enctype="multipart/form-data">
    <input name="_method" type="hidden" value="PATCH">
    <input type="hidden" name="lang" value="{{ $lang }}">
    @csrf
    <div class="row">
        <div class="col-lg-12">
            <div class="eg-card product-card">
                <div class="main-tab-content">
                    <div class="d-flex align-items-start">
                        <div class="nav flex-column nav-pills me-3 border-end pe-3" id="v-pills-tab" role="tablist"
                            aria-orientation="vertical">
                            <button class="nav-link active" id="v-pills-general-tab" data-bs-toggle="pill"
                                data-bs-target="#v-pills-general" type="button" role="tab"
                                aria-controls="v-pills-general" aria-selected="true">{{ translate('General') }}</button>
                            <button class="nav-link" id="v-pills-biography-tab" data-bs-toggle="pill"
                                data-bs-target="#v-pills-biography" type="button" role="tab"
                                aria-controls="v-pills-biography" aria-selected="false">{{ translate('Biography')
                                }}</button>
                            <button class="nav-link" id="v-pills-awards-tab" data-bs-toggle="pill"
                                data-bs-target="#v-pills-awards" type="button" role="tab" aria-controls="v-pills-awards"
                                aria-selected="false">{{ translate('Awards') }}</button>
                        </div>
                        <div class="tab-content w-100" id="v-pills-tabContent">
                            <div class="tab-pane fade show active" id="v-pills-general" role="tabpanel"
                                aria-labelledby="v-pills-general-tab" tabindex="0">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Name') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="username-input"
                                                value="{{ old('name', $artistSingle->getTranslation('name')) }}"
                                                name="name" placeholder="{{ translate('Enter Name') }}">
                                            @error('name')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Bio') }}</label>
                                            <textarea class="username-input" name="bio"
                                                placeholder="{{ translate('Enter Bio') }}">{!! old('bio', $artistSingle->getTranslation('bio')) !!}</textarea>
                                            @error('bio')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Birth Year') }}</label>
                                            <select class="select2" id="year" name="dob">
                                                <option value="">{{ translate('Select Option') }}</option>
                                                <option value="{{ $artistSingle->dob }}" selected>{{ $artistSingle->dob
                                                    }}
                                                </option>
                                            </select>
                                            @error('dob')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Nationality') }}</label>
                                            <input type="text" class="username-input"
                                                value="{{ old('nationality', $artistSingle->getTranslation('nationality')) }}"
                                                name="nationality" placeholder="{{ translate('Enter Nationality') }}">
                                            @error('nationality')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Themes') }}</label>
                                            <textarea class="username-input" name="themes"
                                                placeholder="{{ translate('Enter Themes') }}">{{ old('themes', $artistSingle->getTranslation('themes')) }}</textarea>
                                            @error('themes')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Signature') }}</label>
                                            <input type="file" class="username-input" name="signature">
                                            @error('signature')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                            @if ($artistSingle->signature)
                                            <img src="{{ uploaded_asset($artistSingle->signature) }}"
                                                alt="{{ $artistSingle->name }}" width="100">
                                            @endif
                                        </div>

                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-inner file-upload mb-35">
                                            <label class="control-label">{{ translate('Image') }} <span
                                                    class="text-danger">*</span></label>
                                            <div class="dropzone-wrapper">
                                                <div class="dropzone-desc">
                                                    <i class="glyphicon glyphicon-download-alt"></i>
                                                    <p>{{ translate('Choose an image file or drag it here') }}
                                                    </p>
                                                </div>
                                                <input type="file" name="image" class="dropzone featues_image">
                                            </div>
                                            @error('image')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                            <div class="preview-zone hidden mt-3 text-center">
                                                <div class="box box-solid">
                                                    <div class="box-header with-border">
                                                        <div class="box-tools pull-right">
                                                            <button type="button"
                                                                class="btn btn-danger btn-xs remove-preview"
                                                                style="display:none;">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="box-body">
                                                        @if ($artistSingle->image)
                                                        <img src="{{ uploaded_asset($artistSingle->image) }}"
                                                            alt="{{ $artistSingle->name }}" width="100">
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="v-pills-biography" role="tabpanel"
                                aria-labelledby="v-pills-biography-tab" tabindex="0">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Short Description') }}</label>
                                            <textarea class="username-input" name="biography_desc"
                                                placeholder="{{ translate('Enter Short Description') }}">{{ old('biography_desc', $artistSingle->getTranslation('biography_desc')) }}</textarea>
                                            @error('biography_desc')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <h4 class="form-box-title">{{ translate('Career Lists') }}</h4>
                                    <div class="form-box mb-35 text-center">
                                        @php
                                        $career_lists = $artistSingle->getTranslation('career_lists')
                                        ? json_decode($artistSingle->getTranslation('career_lists'))
                                        : '';
                                        @endphp
                                        <div class="g-4" id="careerListMainContent">
                                            @if ($career_lists)
                                            @foreach ($career_lists as $key => $career)
                                            <div class="row career_list mt-3">
                                                <div class="col-lg-12">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Title')}}</label>
                                                        <input type="text" value="{{ $career->title }}"
                                                            name="career[{{ $key }}][title]"
                                                            placeholder="{{translate('Enter Title')}}">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Content')}}</label>
                                                        <textarea class="summernote" name="career[{{ $key }}][content]"
                                                            placeholder="Enter Content">{{ $career->content }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button style="float: right;" type="button"
                                                        class="removeRow eg-btn btn--red rounded px-3">
                                                        <i class="bi bi-x"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            @endforeach
                                            @endif
                                        </div>
                                        <input type="button" value="{{ translate('Add New') }}"
                                            class="eg-btn btn--primary submit--btn mt-15 addCareerList">
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="v-pills-awards" role="tabpanel"
                                aria-labelledby="v-pills-awards-tab" tabindex="0">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-inner mb-35">
                                            <label>{{ translate('Short Description') }}</label>
                                            <textarea class="username-input" name="awards_desc"
                                                placeholder="{{ translate('Enter Short Description') }}">{{ old('awards_desc', $artistSingle->getTranslation('awards_desc')) }}</textarea>
                                            @error('awards_desc')
                                            <div class="error text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <h4 class="form-box-title">{{ translate('Awards Lists') }}</h4>
                                    <div class="form-box mb-35 text-center">
                                        @php
                                        $award_lists = $artistSingle->getTranslation('awards_lists')
                                        ? json_decode($artistSingle->getTranslation('awards_lists'))
                                        : '';
                                        @endphp
                                        <div class="g-4" id="awardsListMainContent">
                                            @if ($award_lists)
                                            @foreach ($award_lists as $key => $award)
                                            <div class="row awards_list mt-3">
                                                <div class="col-lg-12">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Title')}}</label>
                                                        <input type="text" value="{{$award->title}}"
                                                            name="awards[{{$key}}][title]" placeholder="Enter Title">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Content')}}</label>
                                                        <textarea class="summernote" name="awards[{{$key}}][content]"
                                                            placeholder="Enter Content">{{$award->content}}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Year')}}</label>
                                                        <input type="text" value="{{$award->year}}"
                                                            name="awards[{{$key}}][year]" placeholder="Enter Year">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-inner mb-35">
                                                        <label>{{translate('Link')}}</label>
                                                        <input type="text" value="{{$award->link}}"
                                                            name="awards[{{$key}}][link]" placeholder="Enter Link">
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button style="float: right;" type="button"
                                                        class="removeRow eg-btn btn--red rounded px-3">
                                                        <i class="bi bi-x"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            @endforeach
                                            @endif
                                        </div>
                                        <input type="button" value="{{ translate('Add New') }}"
                                            class="eg-btn btn--primary submit--btn mt-15 addAwardsList">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="button-group mt-15 text-center  ">
                    <input type="submit" class="eg-btn btn--green back-btn me-3" value="{{ translate('Update') }}">
                </div>
            </div>
        </div>
    </div>
</form>
@endsection
@push('js')
@include('js.admin.artist')
@endpush