@extends('frontend.template-1.layouts.master')

@section('content')
@include('frontend.template-1.partials.breadcrumb')
    <div class="login-section mb-120">
        <div class="container">
            <div class="row d-flex justify-content-center g-4">
                <div class="col-xl-6 col-lg-8 col-md-10">
                    <div class="login-form-wrapper">
                        <div class="form-title">
                            <p>{{translate('This is a secure area of the application. Please confirm your password before continuing.')}}</p>
                        </div>
                        <form class="w-100" method="POST" action="{{ route('password.confirm') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-inner">
                                        <label>{{translate('Password')}} <span class="text-danger">*</span></label>
                                        <input type="password" name="password" id="password" placeholder="{{translate('Password')}}" 
                            required autocomplete="current-password"/>
                                        <i class="bi bi-eye-slash" id="togglePassword"></i>
                                        @error('password')
                                            <div class="error text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                            </div>
                            <button class="primary-btn1 btn-hover" type="submit">
                                <span>{{translate('Confirm')}}</span>
                                <strong></strong>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection