<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('artists', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('name');
            $table->string('slug');
            $table->text('bio')->nullable();
            $table->string('dob')->nullable();
            $table->string('nationality')->nullable();
            $table->text('themes')->nullable();
            $table->text('biography_desc')->nullable();
            $table->longText('career_lists')->nullable();
            $table->text('awards_desc')->nullable();
            $table->longText('awards_lists')->nullable();
            $table->string('image')->nullable();
            $table->string('signature')->nullable();
            $table->integer('isFeatured')->default(2)->comment('Yes=1, No=2');
            $table->integer('status')->default(1)->comment('Active=1, Inactive=2');
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('artists');
    }
};
