<?php

namespace App\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        parent::boot();

         $this->installerRoutes();

        // Admin routes
        Route::middleware(['web', 'auth', 'verified', 'backend'])
            ->prefix('dashboard')
            ->as('dashboard.')
            ->group(base_path('routes/admin.php'));

        // Auth routes
        Route::middleware(['web', 'pverify'])
            ->group(base_path('routes/auth.php'));

        // Web routes
        Route::middleware('web')
            ->group(base_path('routes/web.php'));


    }

    protected function installerRoutes()
    {
        Route::middleware('web')
            ->namespace($this->namespace)
            ->group(base_path('routes/installer.php'));
    }
}
