<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        /* Bootstrap Pagination */
        Paginator::useBootstrap();

         if ($this->alreadyInstalled() !==false) {

            /* Define Blade Admin */
            Blade::if('admin', function () {
                return Auth::check() && Auth::user()->role == 3;
            });

            Blade::if('agent', function () {
                return Auth::check() && Auth::user()->role == 2;
            });

            Blade::if('adminOrAgent', function () {
                return Auth::check() && in_array(Auth::user()->role, [2, 3]);
            });

        }
    }

    public function alreadyInstalled()
    {
        return file_exists(storage_path('installed'));
    }
}
