<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $guarded = [];

    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function artworks()
    {
        return $this->belongsTo(Artwork::class, 'artwork_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class, 'order_id');
    }
    public function address()
    {
        return $this->hasMany(Address::class, 'order_id');
    }
}
