<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Menu extends Model
{
    protected $guarded = [];
    
    protected $with = ['menu_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $menu_translations = $this->menu_translations->where('lang', $lang)->first();

        return $menu_translations != null ? $menu_translations->$field : $this->$field;
    }

    public function menu_translations()
    {
        return $this->hasMany(MenuTranslation::class);
    }

}
