<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Location extends Model
{
    protected $with = ['location_translations'];

    public function getTranslation($field = '', $lang = false){
        $lang = $lang == false ? App::getLocale() : $lang;
        $location_translations = $this->location_translations->where('lang', $lang)->first();
        return $location_translations != null ? $location_translations->$field : $this->$field;
    }

    public function location_translations(){
    	return $this->hasMany(LocationTranslation::class);
    }

}
