<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Artwork extends Model
{

    protected $guarded = [];
    
    protected $with = ['artwork_translations'];

    public function getTranslation($field = '', $lang = false)
    {
        $lang = $lang == false ? App::getLocale() : $lang;
        $artwork_translations = $this->artwork_translations->where('lang', $lang)->first();

        return $artwork_translations != null ? $artwork_translations->$field : $this->$field;
    }

    public function artwork_translations()
    {
        return $this->hasMany(ArtworkTranslation::class);
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'artwork_categories', 'artwork_id', 'category_id');
    }

    public function artists()
    {
        return $this->belongsTo(Artist::class, 'artist_id');
    }

    public function users()
    {
        return $this->belongsTo(User::class, 'author_id');
    }

    public function galleries()
    {
        return $this->hasMany(ArtworkGallery::class, 'artwork_id');
    }

    public function bids()
    {
        return $this->hasMany(Order::class,'artwork_id')->where('type',1)->latest();
    }

    public function direct_sales()
    {
        return $this->hasMany(Order::class,'artwork_id')->where('type',2)->latest();
    }

    public function bid_winners()
    {
        return $this->hasMany(Order::class,'artwork_id')->where('type',1)->whereIn('status',[2,4,6,8])->latest();
    }

    public function wishlists(){
        return $this->hasMany(Wishlist::class,'artwork_id');
    }

}
