<?php

namespace App\Http\Services\Payment;

use Razorpay\Api\Api;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;

class RazorpayService
{
    protected $api;

    public function __construct()
    {
        $this->api = new Api(
            get_payment_method('razorpay_key'),
            get_payment_method('razorpay_secret')
        );
    }

    public function createOrder($customerInfo)
{
    try {
        $conversionRate = get_payment_method('razorpay_conversion') ?? 1;
        $inrAmount = $customerInfo['total_amount'] / $conversionRate;
        $mainAmount = (int) round($inrAmount * 100);

        if ($mainAmount < 100) {
            return redirect()->route('payment.error')->with('error',translate('Minimum amount should be ₹1 or more.'));
        }

        $receiptId = Str::random(20);

        $order = $this->api->order->create([
            'receipt' => $receiptId,
            'amount' => $mainAmount,
            'currency' => 'INR',
            'payment_capture' => 1,
        ]);

        Session::put('customer_info', $customerInfo);
        Session::put('razorpay_order_id', $order['id']);

        return [
            'orderId' => $order['id'],
            'razorpayKey' => get_payment_method('razorpay_key'),
            'amount' => $mainAmount,
            'currency' => 'INR',
            'name' => $customerInfo['name'],
            'email' => $customerInfo['email'],
            'contact' => $customerInfo['phone'],
            'description' => getPaymentDetails($customerInfo['type'], $customerInfo),
        ];
    } catch (\Throwable $e) {
        return redirect()->route('payment.error')->with('error','Server error: ' . $e->getMessage());
    }
}

public function verifyPayment($request)
    {
        $attributes = [
            'razorpay_order_id' => $request->razorpay_order_id,
            'razorpay_payment_id' => $request->razorpay_payment_id,
            'razorpay_signature' => $request->razorpay_signature,
        ];

        try {
            $this->api->utility->verifyPaymentSignature($attributes);
            $data['status'] = 'success';
            $data['payment_id'] = $attributes['razorpay_payment_id'];
            $data['customer_info'] = Session::get('customer_info');
            return $data;
        } catch (\Exception $e) {
            return redirect()->route('payment.error')->with('error','Server error: ' . $e->getMessage());
        }
    }

}
