<?php

namespace App\Http\Requests;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'fname' => 'required|string|max:255',
            'lname' => 'required|string|max:255',
            'address' => 'nullable|string|max:255',
            'country_id' => 'nullable|integer|exists:locations,id',
            'state_id' => 'nullable|integer|exists:locations,id',
            'city_id' => 'nullable|integer|exists:locations,id',
            'zip_code' => 'nullable|string|max:20',
            'email' => 'nullable|max:20|unique:users,email,' . auth()->id(),
            'phone' => 'nullable|max:20|unique:users,phone,' . auth()->id(),
            'password' => 'nullable|string|min:8|confirmed',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:2048',
        ];
    }
}
