<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class MenuItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return false;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
             'title'=>'required', Rule::unique('menu_items', 'title')->ignore(Request()->id),
         ];
    }

    /**
      * Get the error messages for the defined validation rules.
      *
      * @return array<string, string>
     */

     public function messages(): array
     {
         return [
             'title.required' => translate('Menu Item Name is required.'),
             'title.unique' => translate('Menu Item Name Already exists.'),
         ];
     }

     public function failedValidation(Validator $validator)
     {
         throw new HttpResponseException(response()->json([
             'status'   => false,
             'errors'   => $validator->errors()
         ]));
     }
}
