<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\Order;
use App\Models\Artwork;

class CheckoutController extends Controller
{
    public function index()
    {
        $cart_data = Session::get('cart_data');
        $title = translate('Checkout Page');
        // Logic to show the checkout page
        return view('frontend.template-' . selectedTheme() . '.pages.checkout',compact('cart_data','title'));
    }

    public function checkout(Request $request)
    {
        if (isset($request->current_bid) && $request->current_bid >= $request->price) {
            return redirect()->back()->with('error', translate('Your Bid is not bigger then current Bid'));
        }

        $bid_null = ArtWork::where('sale_type', 1)->where('id', $request->artwork_id)->where('min_deposit', 0)->first(); 
        $user = Auth::user();
        if($bid_null) {
            $orders = new Order;
            $orders->order_number = random_number();
            $orders->artwork_id = $request->artwork_id ;
            $orders->user_id = $user->id;
            $orders->type = 1;
            $orders->amount = $request->price;
            $orders->tax_rate = get_setting('tax_rate');
            $orders->quantity = 1;
            $orders->payment_status = 2; // Unpaid
            if($orders->save()){
                generate_address($orders->id, $request);
            }
            return redirect()->route('thank_you')->with(['success' => translate('Order successfully! Your Order ID is:') . $orders->order_number, 'orders' => $orders]);
        }

        if (isset($request->price) && isset($request->artwork_id)) {
            $cart_data = [
                'quantity' => $request->quantity ?? 1,
                'price' => $request->price ?? 0,
                'artwork_id' => $request->artwork_id,
            ];

            Session::put('cart_data', $cart_data);

            return redirect()->route('checkout.page');
        } else {
            return view('frontend.error.index');
        }
    }


    public function thank_you()
    {
        $title = translate('Thank You');

        $type = Session::get('artwork_type') ?? 'auction';
        // Logic to show the thank you page
        // You can pass any necessary data to the view
        return view('frontend.template-' . selectedTheme() . '.pages.thank_you', compact('title','type'));
    }
}
