<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use Illuminate\Support\Facades\Auth;

class WinnerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $page_title = translate('Winner List');
        $user = Auth::user();

        $winners = Order::select('orders.*')
            ->join('artworks', 'artworks.id', '=', 'orders.artwork_id')
            ->when($user->role != 3, function ($q) use ($user) {
                return $q->where('artworks.author_id', $user->id);
            })
            ->when($request->search, function ($q) use ($request) {
                return $q->where('artworks.name', 'LIKE', '%' . $request->search . '%');
            })
            ->where('orders.type', 1)
            ->where('orders.win_status', 1)
            ->latest()->paginate(12);
        return view('backend.winner.index', compact('page_title', 'winners'));
    }
}
