<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;

class TransactionController extends Controller
{
        /**
     * Display a listing of the resource.
     */
   public function index(Request $request)
{
    $page_title = translate('Transaction List');
    $user = Auth::user();
    $transactions = Transaction::whereNotIn('type',[1,4])->when($user->role != 3, function ($query) use ($user) {
        $query->where('user_id', $user->id);
    })->when($request->search, function ($query, $search) {
            $query->where(function ($q) use ($search) {
                $q->where('user_id', 'LIKE', "%$search%")
                  ->orWhere('payment_method', 'LIKE', "%$search%")
                  ->orWhere('total_amount', 'LIKE', "%$search%")
                  ->orWhere('tax_amount', 'LIKE', "%$search%");
            });
        })
        ->latest()
        ->paginate(10);

    return view('backend.transactions.index', compact('page_title', 'transactions', 'user'));
}
}
