<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\Artisan;

class FrontendSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }

    public function index()
    {
        return view('backend.frontend_setting.index', [
            'page_title' => translate('Frontend Settings'),
            'frontend_setting' => Setting::all(),
        ]);
    }

    public function store(Request $request)
    {
        $defaultOffSettings = [
        'footer_bottom', 'footer_bottom_menu', 'gdpr_cookie_enabled', 'footer_mailchimp_status', 'footer1_status', 'footer2_status', 'footer3_status', 'footer4_status',
        ];

        // Handle toggles that may not be submitted
        foreach ($defaultOffSettings as $key) {
            if (!$request->has($key)) {
                Setting::updateOrCreate(['type' => $key], ['value' => 0]);
            }
        }


        foreach ($request->except('_token') as $key => $value) {
            $setting = Setting::firstOrNew(['type' => $key]);

            if (in_array($key, ['main_logo', 'white_logo', 'footer_logo', 'front_favicon', 'payment_method_img', 'meta_img'])) {
                if ($request->hasFile($key)) {
                    $file = $request->file($key);
                    $old = get_setting($key);
                    if ($old && file_exists(file_path().$old)) {
                        unlink(file_path().$old);
                    }
                    $setting->value = uploadImage($file);
                }

            } else {
                $setting->value = $value;
            }

            $setting->save();
        }

        Artisan::call('cache:clear');
        return back()->with('success', 'Frontend settings saved successfully.');
    }

}
