<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmailTemplate;
use Illuminate\Support\Facades\Validator;

class EmailTemplateController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $page_title = translate('Email Template');
        $email_templates = EmailTemplate::where('status', 1)->get();
        return view('backend.email_template.index', compact('page_title', 'email_templates'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $page_title = translate('Edit Email Template');
        $emailTemplateSingle = EmailTemplate::findOrFail($id);
        return view('backend.email_template.edit', compact('page_title', 'emailTemplateSingle'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $validated = $request->validate([
            'name' => 'required|max:255',
            'subject' => 'required|max:255',
            'body' => 'required',
        ]);

        $dom = new \DomDocument();
        @$dom->loadHtml($request->body, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);

        foreach ($dom->getElementsByTagName('img') as $i => $img) {
            $src = $img->getAttribute('src');
            if (str_contains($src, ';')) {
                [, $data] = explode(',', $src);
                $path = '/uploads/files/' . time() . $i . '.png';
                file_put_contents(public_path($path), base64_decode($data));
                $img->setAttribute('src', $path);
            }
        }

        $emailTemplate = EmailTemplate::findOrFail($id);
        $emailTemplate->update([
            'name' => $validated['name'],
            'subject' => $validated['subject'],
            'body' => str_replace('script', '', html_entity_decode($dom->saveHTML())),
        ]);

        return redirect()->route('dashboard.email.template.index')->with('success', translate('Email Template updated successfully'));

    }

}
