<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;

class DepositController extends Controller
{
        /**
     * Display a listing of the resource.
     */
   public function index(Request $request)
{
    $page_title = translate('Deposit List');
    $deposits = Transaction::where('type', 1)
        ->when($request->search, function ($query, $search) {
            $query->where(function ($q) use ($search) {
                $q->where('user_id', 'LIKE', "%$search%")
                  ->orWhere('payment_method', 'LIKE', "%$search%")
                  ->orWhere('transaction_id', 'LIKE', "%$search%")
                  ->orWhere('currency', 'LIKE', "%$search%")
                  ->orWhere('amount', 'LIKE', "%$search%");
            });
        })
        ->latest()
        ->paginate(10);

    return view('backend.deposits.index', compact('page_title', 'deposits'));
}
}
