<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;

class ContactController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'admin']);
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $page_title = translate('Contact List');

        $contacts = Contact::query()
        ->when($request->search, function ($query) use ($request) {
            $query->where('name', 'like', '%' . $request->search . '%')
                    ->orWhere('email', 'like', '%' . $request->search . '%');
        })->latest()->paginate(10);

        return view('backend.contact.index', compact('page_title', 'contacts'));
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        $contactSingle = Contact::findOrFail($id);
        $contactSingle->isRead = 1;
        $contactSingle->update();

        $page_title = $contactSingle->name;

        return view('backend.contact.show', compact('page_title', 'contactSingle'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $contact = Contact::findOrFail($id);
        $contact->delete();
        return back()->with('success', translate('Contact deleted successfully'));
    }
}
