<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminAuthController extends Controller
{
       /**
 * Display a listing of the resource.
 */
public function index(Request $request)
{
    $page_title = translate('Admin Login');

    return view('auth.admin-login', compact('page_title'));
}

public function login(Request $request)
{
    $credentials = $request->validate([
        'email' => 'required|email',
        'password' => 'required',
    ]);

    if (Auth::attempt($credentials, $request->remember)) {
        $request->session()->regenerate();

        // Check user role
        $user = Auth::user();
        if ($user->role == 3) {
            return redirect()->intended(route('dashboard.index', absolute: false));
        }

        // Logout if not admin
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return back()->withErrors([
            'status' => 'Access denied. Only admin users are allowed.',
        ]);
    }

    return back()->withErrors([
        'status' => 'Invalid credentials.',
    ])->onlyInput('status');
}

}